/*
 * Decompiled with CFR 0.152.
 */
package mods.belgabor.bitdrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawersComp;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.storage.BaseDrawerData;
import com.jaquadro.minecraft.storagedrawers.storage.ICentralInventory;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitVisitor;
import mod.chiselsandbits.api.ItemType;
import mods.belgabor.bitdrawers.BitDrawers;
import mods.belgabor.bitdrawers.core.BDLogger;
import mods.belgabor.bitdrawers.core.BitHelper;
import mods.belgabor.bitdrawers.storage.BitDrawerData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileBitDrawers
extends TileEntityDrawers {
    private static InventoryLookup lookup1 = new InventoryLookup(1, 1);
    private static InventoryLookup lookup2 = new InventoryLookup(2, 2);
    private static InventoryLookup lookup3 = new InventoryLookup(3, 3);
    private ICentralInventory centralInventory;
    private int pooledCount;
    private int lookupSizeResult;
    private ItemStack[] protoStack = new ItemStack[this.getDrawerCount()];
    private int[] convRate = new int[this.getDrawerCount()];

    public TileBitDrawers() {
        super(3);
    }

    protected ICentralInventory getCentralInventory() {
        if (this.centralInventory == null) {
            this.centralInventory = new BitCentralInventory();
        }
        return this.centralInventory;
    }

    public int getStoredItemRemainder(int slot) {
        int count = this.centralInventory.getStoredItemCount(slot);
        if (slot > 0 && this.convRate[slot] > 0) {
            count -= this.centralInventory.getStoredItemCount(slot - 1) * (this.convRate[slot - 1] / this.convRate[slot]);
        }
        return count;
    }

    protected IDrawer createDrawer(int slot) {
        return new BitDrawerData(this.getCentralInventory(), slot);
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerDrawersComp(playerInventory, (TileEntityDrawers)this);
    }

    public String func_174875_k() {
        return "StorageDrawers:compDrawers";
    }

    public boolean isDrawerEnabled(int slot) {
        if (slot > 0 && this.convRate[slot] == 0) {
            return false;
        }
        return super.isDrawerEnabled(slot);
    }

    public int interactPutItemsIntoSlot(int slot, EntityPlayer player) {
        ItemStack stack;
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("TileBitDrawers:interactPutItemsIntoSlot %d", slot);
        }
        if ((stack = player.field_71071_by.func_70448_g()) != null) {
            ItemType type;
            if (stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                return this.interactPutBagIntoSlot(slot, stack);
            }
            if (slot == 2 && ((type = BitDrawers.cnb_api.getItemType(stack)) == ItemType.POSITIVE_DESIGN || type == ItemType.NEGATIVE_DESIGN || type == ItemType.MIRROR_DESIGN)) {
                return this.interactSetCustomSlot(stack);
            }
        }
        return super.interactPutItemsIntoSlot(slot, player);
    }

    public int interactPutBagIntoSlot(int slot, ItemStack stack) {
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("TileBitDrawers:interactPutBagIntoSlot %d %s", slot, stack == null ? "null" : stack.func_82833_r());
        }
        int added = 0;
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler instanceof IBitBag) {
            slot = 1;
            if (BitDrawers.config.debugTrace) {
                BDLogger.info("TileBitDrawers:interactPutBagIntoSlot Bit Bag detected", new Object[0]);
            }
        }
        block0: for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extract;
            while ((extract = handler.extractItem(i, 64, true)) != null) {
                int extracted = extract.field_77994_a;
                int inserted = this.putItemsIntoSlot(slot, extract, extracted);
                if (inserted > 0) {
                    added += inserted;
                    ItemStack test = handler.extractItem(i, inserted, false);
                    if (test.field_77994_a < inserted) {
                        BDLogger.error("Could not extract simulated amount from bag. Something went very wrong.", new Object[0]);
                    }
                }
                if (inserted >= extracted) continue;
                continue block0;
            }
        }
        return added;
    }

    public int interactSetCustomSlot(ItemStack stack) {
        IBitBrush brush;
        ItemStack bit = this.getDrawer(1).getStoredItemPrototype();
        if (bit == null) {
            return 0;
        }
        try {
            brush = BitDrawers.cnb_api.createBrush(bit);
        }
        catch (APIExceptions.InvalidBitItem e) {
            return 0;
        }
        ItemStack item = BitHelper.getMonochrome(stack, brush);
        if (item == null || item.field_77994_a == 0) {
            this.populateSlot(2, null, 0);
        } else {
            this.populateSlot(2, item, item.field_77994_a);
        }
        return 1;
    }

    public int putItemsIntoSlot(int slot, ItemStack stack, int count) {
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("TileBitDrawers:putItemsIntoSlot %d %s %d", slot, stack == null ? "null" : stack.func_82833_r(), count);
        }
        int added = 0;
        if (stack != null) {
            if (BitDrawers.cnb_api.getItemType(stack) == ItemType.CHISLED_BLOCK) {
                return this.putChiseledBlockIntoDrawer(stack, count);
            }
            if (this.convRate != null && this.convRate[0] == 0) {
                int i;
                this.populateSlots(stack);
                for (i = 0; i < this.getDrawerCount(); ++i) {
                    if (!BaseDrawerData.areItemsEqual((ItemStack)this.protoStack[i], (ItemStack)stack)) continue;
                    added = super.putItemsIntoSlot(i, stack, count);
                }
                for (i = 0; i < this.getDrawerCount(); ++i) {
                    IDrawer drawer = this.getDrawer(i);
                    if (!(drawer instanceof BitDrawerData)) continue;
                    ((BitDrawerData)drawer).refresh();
                }
            }
        }
        return added + super.putItemsIntoSlot(slot, stack, count);
    }

    public int putChiseledBlockIntoDrawer(ItemStack stack, int count) {
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("TileBitDrawers:putChiseledBlockIntoDrawer %s %d", stack == null ? "null" : stack.func_82833_r(), count);
        }
        count = Math.min(count, stack.field_77994_a);
        IDrawer drawer = this.getDrawer(1);
        IBitAccess access = BitDrawers.cnb_api.createBitItem(stack);
        if (this.convRate == null || this.convRate[0] == 0 || access == null) {
            return 0;
        }
        BitHelper.BitCounter counter = new BitHelper.BitCounter();
        access.visitBits((IBitVisitor)counter);
        IBitBrush stored = null;
        try {
            stored = BitDrawers.cnb_api.createBrush(drawer.getStoredItemPrototype());
        }
        catch (APIExceptions.InvalidBitItem invalidBitItem) {
            BDLogger.error("Failed to create bit brush for stored bit", new Object[0]);
            BDLogger.error(invalidBitItem);
            return 0;
        }
        if (counter.counts.size() != 1 || !counter.counts.containsKey(stored.getStateID()) || counter.counts.get(stored.getStateID()) == 0) {
            if (BitDrawers.config.debugTrace) {
                BDLogger.info("TileBitDrawers:putChiseledBlockIntoDrawer Not Matched %d", counter.counts.size());
            }
            return 0;
        }
        int bitSize = counter.counts.get(stored.getStateID());
        int canStore = this.isVoid() ? count : drawer.getRemainingCapacity() / bitSize;
        int toStore = Math.min(canStore, count);
        int toStoreBits = toStore * bitSize;
        ItemStack store = drawer.getStoredItemPrototype().func_77946_l();
        store.field_77994_a = toStoreBits;
        int storedBits = super.putItemsIntoSlot(1, store, toStoreBits);
        if (storedBits != toStoreBits) {
            BDLogger.error("Couldn't store bits when inserting chiseled block. This is not supposed to happen at this point.", new Object[0]);
            toStore = storedBits / bitSize;
        }
        stack.field_77994_a -= toStore;
        return toStore;
    }

    public void readFromPortableNBT(NBTTagCompound tag) {
        int i;
        this.pooledCount = 0;
        for (i = 0; i < this.getDrawerCount(); ++i) {
            this.protoStack[i] = null;
            this.convRate[i] = 0;
        }
        super.readFromPortableNBT(tag);
        this.pooledCount = tag.func_74762_e("Count");
        if (tag.func_74764_b("Conv0")) {
            this.convRate[0] = tag.func_74762_e("Conv0");
        }
        if (tag.func_74764_b("Conv1")) {
            this.convRate[1] = tag.func_74762_e("Conv1");
        }
        if (tag.func_74764_b("Conv2")) {
            this.convRate[2] = tag.func_74762_e("Conv2");
        }
        for (i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!(drawer instanceof BitDrawerData)) continue;
            ((BitDrawerData)drawer).refresh();
        }
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public NBTTagCompound writeToPortableNBT(NBTTagCompound tag) {
        super.writeToPortableNBT(tag);
        tag.func_74768_a("Count", this.pooledCount);
        if (this.convRate[0] > 0) {
            tag.func_74768_a("Conv0", this.convRate[0]);
        }
        if (this.convRate[1] > 0) {
            tag.func_74768_a("Conv1", this.convRate[1]);
        }
        if (this.convRate[2] > 0) {
            tag.func_74768_a("Conv2", this.convRate[2]);
        }
        return tag;
    }

    public void clientUpdateCount(int slot, int count) {
        if (count != this.pooledCount) {
            this.pooledCount = count;
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public String func_70005_c_() {
        return "bitDrawers.container.bitDrawers";
    }

    private void populateSlots(ItemStack stack) {
        if (BitDrawers.cnb_api.getItemType(stack) == ItemType.CHISLED_BIT) {
            ItemStack fullStack = BitHelper.getBlock(stack);
            if (fullStack != null) {
                this.populateSlot(0, fullStack, 4096);
                this.populateSlot(1, stack, 1);
            }
        } else {
            ItemStack bitStack = BitHelper.getBit(stack);
            if (bitStack != null) {
                this.populateSlot(0, stack, 4096);
                this.populateSlot(1, bitStack, 1);
            }
        }
    }

    private void populateSlot(int slot, ItemStack stack, int conversion) {
        this.convRate[slot] = conversion;
        ItemStack itemStack = this.protoStack[slot] = stack == null ? null : stack.func_77946_l();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    private static class InventoryLookup
    extends InventoryCrafting {
        private ItemStack[] stackList;

        public InventoryLookup(int width, int height) {
            super(null, width, height);
            this.stackList = new ItemStack[width * height];
        }

        public int func_70302_i_() {
            return this.stackList.length;
        }

        public ItemStack func_70301_a(int slot) {
            return slot >= this.func_70302_i_() ? null : this.stackList[slot];
        }

        public ItemStack func_70304_b(int slot) {
            return null;
        }

        public ItemStack func_70298_a(int slot, int count) {
            return null;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.stackList[slot] = stack;
        }
    }

    private class BitCentralInventory
    implements ICentralInventory {
        private BitCentralInventory() {
        }

        public ItemStack getStoredItemPrototype(int slot) {
            return TileBitDrawers.this.protoStack[slot];
        }

        public IDrawer setStoredItem(int slot, ItemStack itemPrototype, int amount) {
            if (BitDrawers.config.debugTrace) {
                BDLogger.info("setStoredItem %d %s %d", slot, itemPrototype == null ? "null" : itemPrototype.func_82833_r(), amount);
            }
            if (itemPrototype != null && TileBitDrawers.this.convRate != null && TileBitDrawers.this.convRate[0] == 0) {
                int i;
                TileBitDrawers.this.populateSlots(itemPrototype);
                for (i = 0; i < TileBitDrawers.this.getDrawerCount(); ++i) {
                    if (!BaseDrawerData.areItemsEqual((ItemStack)TileBitDrawers.this.protoStack[i], (ItemStack)itemPrototype)) continue;
                    TileBitDrawers.this.pooledCount = TileBitDrawers.this.pooledCount % TileBitDrawers.this.convRate[i] + TileBitDrawers.this.convRate[i] * amount;
                }
                for (i = 0; i < TileBitDrawers.this.getDrawerCount(); ++i) {
                    IDrawer drawer;
                    if (i == slot || !((drawer = TileBitDrawers.this.getDrawer(i)) instanceof BitDrawerData)) continue;
                    ((BitDrawerData)drawer).refresh();
                }
                if (TileBitDrawers.this.func_145831_w() != null && !TileBitDrawers.this.func_145831_w().field_72995_K) {
                    IBlockState state = TileBitDrawers.this.func_145831_w().func_180495_p(TileBitDrawers.this.func_174877_v());
                    TileBitDrawers.this.func_145831_w().func_184138_a(TileBitDrawers.this.func_174877_v(), state, state, 3);
                }
            } else if (itemPrototype == null) {
                this.setStoredItemCount(slot, 0);
            }
            return TileBitDrawers.this.getDrawer(slot);
        }

        public int getStoredItemCount(int slot) {
            if (TileBitDrawers.this.convRate == null || TileBitDrawers.this.convRate[slot] == 0) {
                return 0;
            }
            if (TileBitDrawers.this.isVending()) {
                return Integer.MAX_VALUE;
            }
            return TileBitDrawers.this.pooledCount / TileBitDrawers.this.convRate[slot];
        }

        public void setStoredItemCount(int slot, int amount) {
            if (BitDrawers.config.debugTrace) {
                BDLogger.info("BitCentralInventory:setStoredItemCount %d %d", slot, amount);
            }
            if (TileBitDrawers.this.convRate == null || TileBitDrawers.this.convRate[slot] == 0) {
                return;
            }
            if (TileBitDrawers.this.isVending()) {
                return;
            }
            int oldCount = TileBitDrawers.this.pooledCount;
            TileBitDrawers.this.pooledCount = TileBitDrawers.this.pooledCount % TileBitDrawers.this.convRate[slot] + TileBitDrawers.this.convRate[slot] * amount;
            int poolMax = this.getMaxCapacity(0) * TileBitDrawers.this.convRate[0];
            if (TileBitDrawers.this.pooledCount > poolMax) {
                TileBitDrawers.this.pooledCount = poolMax;
            }
            if (TileBitDrawers.this.pooledCount != oldCount) {
                if (TileBitDrawers.this.pooledCount != 0 || TileBitDrawers.this.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                    this.markAmountDirty();
                } else {
                    this.clear();
                    if (TileBitDrawers.this.func_145831_w() != null && !TileBitDrawers.this.func_145831_w().field_72995_K) {
                        IBlockState state = TileBitDrawers.this.func_145831_w().func_180495_p(TileBitDrawers.this.func_174877_v());
                        TileBitDrawers.this.func_145831_w().func_184138_a(TileBitDrawers.this.func_174877_v(), state, state, 3);
                    }
                }
            }
        }

        public int getMaxCapacity(int slot) {
            if (TileBitDrawers.this.protoStack[slot] == null || TileBitDrawers.this.convRate == null || TileBitDrawers.this.convRate[slot] == 0) {
                return 0;
            }
            if (TileBitDrawers.this.isUnlimited() || TileBitDrawers.this.isVending()) {
                if (TileBitDrawers.this.convRate == null || TileBitDrawers.this.protoStack[slot] == null || TileBitDrawers.this.convRate[slot] == 0) {
                    return Integer.MAX_VALUE;
                }
                return Integer.MAX_VALUE / TileBitDrawers.this.convRate[slot];
            }
            return TileBitDrawers.this.protoStack[slot].func_77973_b().getItemStackLimit(TileBitDrawers.this.protoStack[slot]) * this.getStackCapacity(slot);
        }

        public int getMaxCapacity(int slot, ItemStack itemPrototype) {
            if (itemPrototype == null || itemPrototype.func_77973_b() == null) {
                return 0;
            }
            if (TileBitDrawers.this.isUnlimited() || TileBitDrawers.this.isVending()) {
                if (TileBitDrawers.this.convRate == null || TileBitDrawers.this.protoStack[slot] == null || TileBitDrawers.this.convRate[slot] == 0) {
                    return Integer.MAX_VALUE;
                }
                return Integer.MAX_VALUE / TileBitDrawers.this.convRate[slot];
            }
            if (TileBitDrawers.this.convRate == null || TileBitDrawers.this.protoStack[0] == null || TileBitDrawers.this.convRate[0] == 0) {
                return itemPrototype.func_77973_b().getItemStackLimit(itemPrototype) * this.getBaseStackCapacity();
            }
            if (BaseDrawerData.areItemsEqual((ItemStack)TileBitDrawers.this.protoStack[slot], (ItemStack)itemPrototype)) {
                return this.getMaxCapacity(slot);
            }
            return 0;
        }

        public int getRemainingCapacity(int slot) {
            if (TileBitDrawers.this.isVending()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity(slot) - this.getStoredItemCount(slot);
        }

        public int getStoredItemStackSize(int slot) {
            if (TileBitDrawers.this.protoStack[slot] == null || TileBitDrawers.this.convRate == null || TileBitDrawers.this.convRate[slot] == 0) {
                return 0;
            }
            return TileBitDrawers.this.protoStack[slot].func_77973_b().getItemStackLimit(TileBitDrawers.this.protoStack[slot]);
        }

        public int getItemCapacityForInventoryStack(int slot) {
            if (TileBitDrawers.this.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity(slot);
        }

        public int getConversionRate(int slot) {
            if (TileBitDrawers.this.protoStack[slot] == null || TileBitDrawers.this.convRate == null || TileBitDrawers.this.convRate[slot] == 0) {
                return 0;
            }
            return TileBitDrawers.this.convRate[0] / TileBitDrawers.this.convRate[slot];
        }

        public int getStoredItemRemainder(int slot) {
            return TileBitDrawers.this.getStoredItemRemainder(slot);
        }

        public boolean isSmallestUnit(int slot) {
            if (TileBitDrawers.this.protoStack[slot] == null || TileBitDrawers.this.convRate == null || TileBitDrawers.this.convRate[slot] == 0) {
                return false;
            }
            return TileBitDrawers.this.convRate[slot] == 1;
        }

        public boolean isVoidSlot(int slot) {
            return TileBitDrawers.this.isVoid();
        }

        public boolean isShroudedSlot(int slot) {
            return TileBitDrawers.this.isShrouded();
        }

        public boolean setIsSlotShrouded(int slot, boolean state) {
            TileBitDrawers.this.setIsShrouded(state);
            return true;
        }

        public boolean isSlotShowingQuantity(int i) {
            return TileBitDrawers.this.isShowingQuantity();
        }

        public boolean setIsSlotShowingQuantity(int slot, boolean state) {
            return TileBitDrawers.this.setIsShowingQuantity(state);
        }

        public boolean isLocked(int slot, LockAttribute attr) {
            return TileBitDrawers.this.isItemLocked(attr);
        }

        public void writeToNBT(int slot, NBTTagCompound tag) {
            ItemStack protoStack = this.getStoredItemPrototype(slot);
            if (protoStack != null && protoStack.func_77973_b() != null) {
                tag.func_74777_a("Item", (short)Item.func_150891_b((Item)protoStack.func_77973_b()));
                tag.func_74777_a("Meta", (short)protoStack.func_77952_i());
                tag.func_74768_a("Count", 0);
                if (protoStack.func_77978_p() != null) {
                    tag.func_74782_a("Tags", (NBTBase)protoStack.func_77978_p());
                }
            }
        }

        public void readFromNBT(int slot, NBTTagCompound tag) {
            Item item;
            if (tag.func_74764_b("Item") && (item = Item.func_150899_d((int)tag.func_74765_d("Item"))) != null) {
                ItemStack stack = new ItemStack(item);
                stack.func_77964_b((int)tag.func_74765_d("Meta"));
                if (tag.func_74764_b("Tags")) {
                    stack.func_77982_d(tag.func_74775_l("Tags"));
                }
                ((TileBitDrawers)TileBitDrawers.this).protoStack[slot] = stack;
            }
        }

        private void clear() {
            for (int i = 0; i < TileBitDrawers.this.getDrawerCount(); ++i) {
                ((TileBitDrawers)TileBitDrawers.this).protoStack[i] = null;
                ((TileBitDrawers)TileBitDrawers.this).convRate[i] = 0;
            }
            this.refresh();
            TileBitDrawers.this.func_70296_d();
        }

        public void refresh() {
            for (int i = 0; i < TileBitDrawers.this.getDrawerCount(); ++i) {
                IDrawer drawer = TileBitDrawers.this.getDrawer(i);
                if (!(drawer instanceof BitDrawerData)) continue;
                ((BitDrawerData)drawer).refresh();
            }
        }

        private int getStackCapacity(int slot) {
            if (TileBitDrawers.this.convRate == null || TileBitDrawers.this.convRate[slot] == 0) {
                return 0;
            }
            int slotStacks = this.getBaseStackCapacity();
            int stackLimit = TileBitDrawers.this.convRate[0] * slotStacks;
            return stackLimit / TileBitDrawers.this.convRate[slot];
        }

        private int getBaseStackCapacity() {
            return TileBitDrawers.this.getEffectiveStorageMultiplier() * TileBitDrawers.this.getDrawerCapacity();
        }

        public void markAmountDirty() {
            if (TileBitDrawers.this.func_145831_w().field_72995_K) {
                return;
            }
            CountUpdateMessage message = new CountUpdateMessage(TileBitDrawers.this.func_174877_v(), 0, TileBitDrawers.this.pooledCount);
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(TileBitDrawers.this.func_145831_w().field_73011_w.getDimension(), (double)TileBitDrawers.this.func_174877_v().func_177958_n(), (double)TileBitDrawers.this.func_174877_v().func_177956_o(), (double)TileBitDrawers.this.func_174877_v().func_177952_p(), 500.0);
            BitDrawers.network.sendToAllAround((IMessage)message, targetPoint);
        }

        public void markDirty(int slot) {
            if (TileBitDrawers.this.func_145831_w().field_72995_K) {
                return;
            }
            IBlockState state = TileBitDrawers.this.func_145831_w().func_180495_p(TileBitDrawers.this.func_174877_v());
            TileBitDrawers.this.func_145831_w().func_184138_a(TileBitDrawers.this.func_174877_v(), state, state, 3);
        }
    }
}

