/*
 * Decompiled with CFR 0.152.
 */
package mods.belgabor.bitdrawers;

import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import mod.chiselsandbits.api.ChiselsAndBitsAddon;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.api.IChiselsAndBitsAddon;
import mods.belgabor.bitdrawers.config.ConfigManager;
import mods.belgabor.bitdrawers.core.BDLogger;
import mods.belgabor.bitdrawers.core.BlockRegistry;
import mods.belgabor.bitdrawers.core.CommonProxy;
import mods.belgabor.bitdrawers.core.RecipeRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="bitdrawers", version="0.36", name="Drawers & Bits", dependencies="required-after:Forge@[12.18.3.2221,);required-after:chiselsandbits@[11.6,);required-after:StorageDrawers@[1.10.2-3.6.1,);required-after:Chameleon", acceptedMinecraftVersions="[1.10.2]")
@ChiselsAndBitsAddon
public class BitDrawers
implements IChiselsAndBitsAddon {
    public static final String MODNAME = "Drawers & Bits";
    public static final String MODID = "bitdrawers";
    public static final String VERSION = "0.36";
    public static final String SD_VERSION = "3.6.1";
    public static final int[] SD_VERSIONS = new int[]{3, 6, 1};
    @SidedProxy(clientSide="mods.belgabor.bitdrawers.client.ClientProxy", serverSide="mods.belgabor.bitdrawers.core.CommonProxy")
    public static CommonProxy proxy;
    public static ConfigManager config;
    public static IChiselAndBitsAPI cnb_api;
    public static SimpleNetworkWrapper network;
    public static boolean sdVersionCheckFailed;
    public static boolean sdMajorMismatch;
    public static boolean sdMinorMismatch;
    public static String detectedSdVersion;
    public static BlockRegistry blocks;
    public static RecipeRegistry recipes;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String[] testVersion;
        BDLogger.logger = event.getModLog();
        config = new ConfigManager(event.getSuggestedConfigurationFile());
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        blocks.init();
        proxy.initClient();
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            network.registerMessage(CountUpdateMessage.Handler.class, CountUpdateMessage.class, 1, Side.CLIENT);
        } else {
            network.registerMessage(CountUpdateMessage.HandlerStub.class, CountUpdateMessage.class, 1, Side.CLIENT);
        }
        ModContainer testContainer = (ModContainer)Loader.instance().getIndexedModList().get("StorageDrawers");
        if (testContainer != null && (testVersion = testContainer.getDisplayVersion().split("-")).length == 2) {
            String[] testVersionParts = testVersion[1].split("\\.");
            detectedSdVersion = testVersion[1];
            if (testVersionParts.length == 3) {
                sdVersionCheckFailed = false;
                try {
                    if (Integer.parseInt(testVersionParts[0]) != SD_VERSIONS[0] || Integer.parseInt(testVersionParts[1]) != SD_VERSIONS[1]) {
                        sdMajorMismatch = true;
                        BDLogger.warn("Your version of Storage Drawers (%s) differs majorly from the one Drawers & Bits was compiled with (%s). Use at your own discretion, in case of issues please open an issue on GitHub and revert the version of Storage Drawers to the one known working until I can fix compatibility.", detectedSdVersion, SD_VERSION);
                    } else if (Integer.parseInt(testVersionParts[2]) != SD_VERSIONS[2]) {
                        sdMinorMismatch = true;
                        BDLogger.warn("Your version of Storage Drawers (%s) differs from the one Drawers & Bits was compiled with (%s). The difference is minor so issues are unlikely, but if one occurs, please open an issue on GitHub and revert the version of Storage Drawers to the one known working until I can fix compatibility.", detectedSdVersion, SD_VERSION);
                    } else if (BitDrawers.config.debugTrace) {
                        BDLogger.info("Drawers & Bits: Storage Drawers version check OK (%s).", detectedSdVersion);
                    }
                }
                catch (NumberFormatException e) {
                    sdVersionCheckFailed = true;
                }
            }
        }
        if (sdVersionCheckFailed) {
            BDLogger.error("Drawers & Bits: Unable to verify StorageDrawers version. This probably isn't going to end well...", new Object[0]);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        recipes.init();
    }

    public void onReadyChiselsAndBits(IChiselAndBitsAPI api) {
        cnb_api = api;
    }

    static {
        sdVersionCheckFailed = true;
        sdMajorMismatch = false;
        sdMinorMismatch = false;
        detectedSdVersion = "";
        blocks = new BlockRegistry();
        recipes = new RecipeRegistry();
    }
}

