/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.gui.client.elements;

import com.valkyrieofnight.valkyrielib.client.SizableBox;
import com.valkyrieofnight.valkyrielib.gui.client.VLGuiContainer;
import com.valkyrieofnight.valkyrielib.gui.client.elements.VLElement;
import java.util.ArrayList;
import java.util.List;

public abstract class VLElementContainer
extends VLElement {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected SizableBox bgStyle;
    protected List<VLElement> elements = new ArrayList<VLElement>();
    private int elementID = 0;
    private int guiLeft;
    private int guiTop;

    public VLElementContainer(VLGuiContainer gui, int x, int y) {
        super(gui);
        this.init(x, y);
    }

    public VLElementContainer(String elementAddress, VLGuiContainer gui, int x, int y) {
        super(elementAddress, gui);
        this.init(x, y);
    }

    private void init(int x, int y) {
        this.bgStyle = null;
        this.x = x;
        this.y = y;
    }

    private void initElements() {
    }

    public VLElementContainer setBackgroundStyle(SizableBox style, int width, int height) {
        this.bgStyle = style;
        return this;
    }

    public void addElement(VLElement ele) {
        if (ele != null) {
            ele.setID(this.elementID++);
            this.elements.add(ele);
        }
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY, int guiLeft, int guiTop) {
        for (VLElement ele : this.elements) {
            ele.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY, guiLeft, guiTop);
        }
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        for (VLElement ele : this.elements) {
            ele.drawGuiContainerForegroundLayer(mouseX, mouseY);
        }
    }

    @Override
    public void updateScreen() {
        for (VLElement e : this.elements) {
            e.updateScreen();
        }
    }

    @Override
    public boolean onMouseClick(int guiLeft, int guiTop, int mouseX, int mouseY, int mouseButton) {
        for (VLElement ele : this.elements) {
            if (!ele.onMouseClick(guiLeft, guiTop, mouseX, mouseY, mouseButton)) continue;
            ele.playPressSound(this.gui.field_146297_k.func_147118_V());
            this.mouseClicked(ele);
        }
        return false;
    }

    public abstract void mouseClicked(VLElement var1);

    @Override
    public boolean drawToolTipAt(int mouseX, int mouseY, int guiLeft, int guiTop) {
        for (VLElement ele : this.elements) {
            ele.drawToolTip(mouseX, mouseY, this.guiLeft, this.guiTop);
        }
        return false;
    }
}

