/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.energy;

import com.valkyrieofnight.valkyrielib.energy.IEnergyInternals;
import com.valkyrieofnight.valkyrielib.energy.IEnergyReceiver;
import com.valkyrieofnight.valkyrielib.util.INBTHandler;
import net.minecraft.nbt.NBTTagCompound;

public class EnergyReceiver
implements IEnergyReceiver,
INBTHandler<EnergyReceiver>,
IEnergyInternals {
    private int energy = 0;
    private int capacity;
    private int maxReceive;

    public EnergyReceiver(int capacity) {
        this(capacity, capacity);
    }

    public EnergyReceiver(int capacity, int maxReceive) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public EnergyReceiver readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74762_e("Energy");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0) {
            this.energy = 0;
        }
        nbt.func_74768_a("Energy", this.energy);
        return nbt;
    }

    @Override
    public void setEnergyStored(int en) {
        this.energy = en;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
    }

    @Override
    public int receiveEnergyInternal(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, maxReceive);
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int extractEnergyInternal(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }
}

