/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.config.old;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.valkyrieofnight.valkyrielib.config.old.property.PropertyCompound;
import com.valkyrieofnight.valkyrielib.json.IJsonSerializable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;

public class VLJsonConfig
implements IJsonSerializable<VLJsonConfig> {
    protected static final Gson SERIALIZER = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(VLJsonConfig.class, (Object)new VLJsonConfig()).create();
    private File configLocation;
    private PropertyCompound entryTemplate;
    private PropertyCompound save;
    private JsonObject originalJson;

    private VLJsonConfig() {
    }

    public VLJsonConfig(File configLocation) {
        if (!configLocation.exists()) {
            configLocation.mkdirs();
        }
        this.configLocation = configLocation;
    }

    protected PropertyCompound getData() {
        return this.save;
    }

    protected void setData(PropertyCompound data) {
        this.save = data;
    }

    protected PropertyCompound getEntryTemplate() {
        return this.entryTemplate;
    }

    protected void setEntryTemplate(PropertyCompound template) {
        this.entryTemplate = template;
    }

    protected JsonObject getOriginalJson() {
        return this.originalJson;
    }

    protected void setOriginalJson(JsonObject obj) {
        this.originalJson = obj;
    }

    public boolean isSavable() {
        return true;
    }

    public JsonElement serialize(VLJsonConfig src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jobj = new JsonObject();
        PropertyCompound srcComp = src.getData();
        return null;
    }

    public VLJsonConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jobj = (JsonObject)json;
        VLJsonConfig config = new VLJsonConfig();
        config.setOriginalJson((JsonObject)json);
        return config;
    }

    private void loadFromOriginal() {
    }

    public static void save(VLJsonConfig config) {
        if (config == null) {
            return;
        }
    }

    public static VLJsonConfig load(File location, PropertyCompound template) {
        if (location == null) {
            return null;
        }
        if (!location.exists()) {
            return null;
        }
        try {
            String json = VLJsonConfig.readJsonFile(location);
            VLJsonConfig config = (VLJsonConfig)SERIALIZER.fromJson(json, VLJsonConfig.class);
            if (config != null) {
                config.setEntryTemplate(template);
                config.loadFromOriginal();
                return config;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String readJsonFile(File file) throws FileNotFoundException {
        StringBuilder jsonSB = new StringBuilder();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            jsonSB = new StringBuilder();
            while ((line = br.readLine()) != null) {
                jsonSB.append(line);
            }
            br.close();
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            e.printStackTrace();
        }
        return jsonSB.toString();
    }

    private static void writeJsonFile(File file, String data) {
        File tmp = new File(file.getAbsolutePath() + "_tmp");
        if (tmp.exists()) {
            tmp.delete();
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmp));
            bw.write(data);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (file.exists()) {
            file.delete();
        }
        if (!file.exists()) {
            tmp.renameTo(file);
        }
    }
}

