/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.moreBees.hives;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import lach_01298.moreBees.Genetics.BeeSpecies;
import lach_01298.moreBees.block.MoreBeesBlocks;
import lach_01298.moreBees.hives.MoreBeesHiveType;
import lach_01298.moreBees.util.Config;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public enum MoreBeesHiveDescription implements IHiveDescription
{
    ROCK(MoreBeesHiveType.ROCK, 2.0f, BeeSpecies.ROCK, HiveManager.genHelper.ground(new Block[]{Blocks.field_150348_b})){

        @Override
        public boolean isGoodBiome(Biome biome) {
            return !BiomeHelper.isBiomeHellish((Biome)biome) && !BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END);
        }

        @Override
        public void postGen(World world, Random rand, BlockPos pos) {
            super.postGen(world, rand, pos);
            if (Config.genHiveFlowers) {
                1.postGenFlowers(world, rand, pos, OreStates);
            }
        }
    };

    private static final IHiveGen groundGen;
    private static final List<IBlockState> OreStates;
    private final IBlockState blockState;
    private final float genChance;
    private final IBeeGenome beeGenome;
    private final IHiveGen hiveGen;

    private MoreBeesHiveDescription(MoreBeesHiveType hiveType, float genChance, BeeSpecies beeTemplate, IHiveGen hiveGen) {
        this.blockState = MoreBeesBlocks.hive.getStateForType(hiveType);
        this.genChance = genChance;
        this.beeGenome = beeTemplate.getGenome();
        this.hiveGen = hiveGen;
    }

    public IHiveGen getHiveGen() {
        return this.hiveGen;
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    public boolean isGoodBiome(Biome biome) {
        return !BiomeHelper.isBiomeHellish((Biome)biome);
    }

    public boolean isGoodHumidity(EnumHumidity humidity) {
        EnumHumidity idealHumidity = this.beeGenome.getPrimary().getHumidity();
        EnumTolerance humidityTolerance = this.beeGenome.getToleranceHumid();
        return AlleleManager.climateHelper.isWithinLimits(humidity, idealHumidity, humidityTolerance);
    }

    public boolean isGoodTemperature(EnumTemperature temperature) {
        EnumTemperature idealTemperature = this.beeGenome.getPrimary().getTemperature();
        EnumTolerance temperatureTolerance = this.beeGenome.getToleranceTemp();
        return AlleleManager.climateHelper.isWithinLimits(temperature, idealTemperature, temperatureTolerance);
    }

    public float getGenChance() {
        return this.genChance;
    }

    public void postGen(World world, Random rand, BlockPos pos) {
    }

    protected static void postGenFlowers(World world, Random rand, BlockPos hivePos, List<IBlockState> flowerStates) {
        int plantedCount = 0;
        for (int i = 0; i < 10; ++i) {
            IBlockState state;
            Block block;
            int xOffset = rand.nextInt(8) - 4;
            int zOffset = rand.nextInt(8) - 4;
            BlockPos blockPos = hivePos.func_177982_a(xOffset, 0, zOffset);
            if (xOffset == 0 && zOffset == 0 || !world.func_175667_e(blockPos) || (blockPos = groundGen.getPosForHive(world, blockPos.func_177958_n(), blockPos.func_177952_p())) == null || !(block = (state = flowerStates.get(rand.nextInt(flowerStates.size()))).func_177230_c()).func_176196_c(world, blockPos)) continue;
            world.func_175656_a(blockPos, state);
            if (++plantedCount >= 5) break;
        }
    }

    static {
        groundGen = HiveManager.genHelper.ground(new Block[]{Blocks.field_150348_b});
        OreStates = new ArrayList<IBlockState>();
        OreStates.addAll((Collection<IBlockState>)Blocks.field_150365_q.func_176194_O().func_177619_a());
        OreStates.addAll((Collection<IBlockState>)Blocks.field_150366_p.func_176194_O().func_177619_a());
    }
}

