/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.structure;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Structure {
    protected final Map<Long, IBlockState> stateMap = new LinkedHashMap<Long, IBlockState>();
    protected final Map<Long, NBTTagCompound> tileMap = new LinkedHashMap<Long, NBTTagCompound>();

    public void placeStateAt(BlockPos pos, IBlockState state) {
        this.stateMap.put(pos.func_177986_g(), state);
    }

    public void placeTileNBTAt(BlockPos pos, NBTTagCompound nbt) {
        this.tileMap.put(pos.func_177986_g(), nbt);
    }

    public IBlockState getStateAt(BlockPos pos) {
        return this.stateMap.get(pos);
    }

    public NBTTagCompound getTileNBTAt(BlockPos pos) {
        return this.tileMap.get(pos);
    }

    protected void build(World world, BlockPos at) {
        for (Long l : this.stateMap.keySet().toArray(new Long[0])) {
            if (l == null) continue;
            BlockPos pos = BlockPos.func_177969_a((long)l);
            NBTTagCompound nbt = this.tileMap.get(l);
            IBlockState state = this.getStateAt(pos);
            world.func_175656_a(at.func_177971_a((Vec3i)pos), state);
            if (nbt == null) continue;
            TileEntity tile = TileEntity.func_190200_a((World)world, (NBTTagCompound)nbt);
            tile.func_174878_a(at.func_177971_a((Vec3i)pos));
            world.func_175690_a(at.func_177971_a((Vec3i)pos), tile);
        }
    }

    protected NBTTagCompound serialize() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Long l : this.stateMap.keySet().toArray(new Long[0])) {
            IBlockState state = this.stateMap.get(l);
            NBTTagCompound tileData = this.tileMap.get(l);
            NBTTagCompound nbt0 = new NBTTagCompound();
            nbt0.func_74772_a("Position", l.longValue());
            nbt0.func_74778_a("Block", state.func_177230_c().getRegistryName().toString());
            nbt0.func_74768_a("Metadata", state.func_177230_c().func_176201_c(state));
            if (tileData != null) {
                nbt0.func_74782_a("TileData", (NBTBase)tileData);
            }
            list.func_74742_a((NBTBase)nbt0);
        }
        nbt.func_74782_a("Blocks", (NBTBase)list);
        return nbt;
    }

    protected void deserialize(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Blocks", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            try {
                NBTTagCompound nbt0 = list.func_150305_b(i);
                long posLong = nbt0.func_74763_f("Position");
                BlockPos pos = BlockPos.func_177969_a((long)posLong);
                IBlockState state = Block.func_149684_b((String)nbt0.func_74779_i("Block")).func_176203_a(nbt0.func_74762_e("Metadata"));
                NBTTagCompound tile = nbt0.func_74775_l("TileData");
                this.placeStateAt(pos, state);
                this.placeTileNBTAt(pos, tile);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

