/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FieldUtil {
    public static void writeFieldsToNBT(Object obj, NBTTagCompound to, boolean privates) {
        try {
            Field[] fs;
            Class<?> c = obj.getClass();
            for (Field f : fs = c.getFields()) {
                int mod;
                if (!f.isAccessible() && !privates || Modifier.isStatic(mod = f.getModifiers())) continue;
                f.setAccessible(true);
                Object oj = f.get(obj);
                Class<Object> o = oj.getClass();
                if (o.isAssignableFrom(Boolean.TYPE)) {
                    to.func_74757_a(f.getName(), ((Boolean)oj).booleanValue());
                    continue;
                }
                if (o.isAssignableFrom(Byte.TYPE)) {
                    to.func_74774_a(f.getName(), ((Byte)oj).byteValue());
                    continue;
                }
                if (o.isAssignableFrom(byte[].class)) {
                    to.func_74773_a(f.getName(), (byte[])oj);
                    continue;
                }
                if (o.isAssignableFrom(Double.TYPE)) {
                    to.func_74780_a(f.getName(), ((Double)oj).doubleValue());
                    continue;
                }
                if (o.isAssignableFrom(Float.TYPE)) {
                    to.func_74776_a(f.getName(), ((Float)oj).floatValue());
                    continue;
                }
                if (o.isAssignableFrom(int[].class)) {
                    to.func_74783_a(f.getName(), (int[])oj);
                    continue;
                }
                if (o.isAssignableFrom(Integer.TYPE)) {
                    to.func_74768_a(f.getName(), ((Integer)oj).intValue());
                    continue;
                }
                if (o.isAssignableFrom(Long.TYPE)) {
                    to.func_74772_a(f.getName(), ((Long)oj).longValue());
                    continue;
                }
                if (o.isAssignableFrom(Short.TYPE)) {
                    to.func_74777_a(f.getName(), ((Short)oj).shortValue());
                    continue;
                }
                if (o.isAssignableFrom(String.class)) {
                    to.func_74778_a(f.getName(), (String)oj);
                    continue;
                }
                if (o.isAssignableFrom(NBTBase.class)) {
                    to.func_74782_a(f.getName(), (NBTBase)oj);
                    continue;
                }
                if (!o.isAssignableFrom(UUID.class)) continue;
                to.func_186854_a(f.getName(), (UUID)oj);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void readFieldsFromNBT(Object to, NBTTagCompound from) {
        try {
            Field[] fs;
            Class<?> c = to.getClass();
            for (Field f : fs = c.getFields()) {
                f.setAccessible(true);
                int mod = f.getModifiers();
                if (Modifier.isStatic(mod)) continue;
                Class<Object> o = f.getType();
                if (o.isAssignableFrom(Boolean.TYPE)) {
                    f.setBoolean(to, from.func_74767_n(f.getName()));
                    continue;
                }
                if (o.isAssignableFrom(Byte.TYPE)) {
                    f.setByte(to, from.func_74771_c(f.getName()));
                    continue;
                }
                if (o.isAssignableFrom(byte[].class)) {
                    f.set(to, from.func_74770_j(f.getName()));
                    continue;
                }
                if (o.isAssignableFrom(Double.TYPE)) {
                    f.setDouble(to, from.func_74769_h(f.getName()));
                    continue;
                }
                if (o.isAssignableFrom(Float.TYPE)) {
                    f.setFloat(to, from.func_74760_g(f.getName()));
                    continue;
                }
                if (o.isAssignableFrom(int[].class)) {
                    f.set(to, from.func_74759_k(f.getName()));
                    continue;
                }
                if (o.isAssignableFrom(Integer.TYPE)) {
                    f.setInt(to, from.func_74762_e(f.getName()));
                    continue;
                }
                if (o.isAssignableFrom(Long.TYPE)) {
                    f.setLong(to, from.func_74763_f(f.getName()));
                    continue;
                }
                if (o.isAssignableFrom(Short.TYPE)) {
                    f.setShort(to, from.func_74765_d(f.getName()));
                    continue;
                }
                if (o.isAssignableFrom(String.class)) {
                    f.set(to, from.func_74779_i(f.getName()));
                    continue;
                }
                if (o.isAssignableFrom(NBTBase.class)) {
                    f.set(to, from.func_74781_a(f.getName()));
                    continue;
                }
                if (!o.isAssignableFrom(UUID.class)) continue;
                f.set(to, from.func_186857_a(f.getName()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

