/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element.button;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.shadowfacts.shadowlib.util.EnumUtils;
import net.shadowfacts.shadowmc.ui.element.button.UIButtonText;
import net.shadowfacts.shadowmc.util.MouseButton;

public class UIButtonEnum<E extends Enum>
extends UIButtonText {
    protected E value;
    protected Function<E, String> localizer;
    protected Consumer<UIButtonEnum<E>> clickHandler;

    public UIButtonEnum(E value, Function<E, String> localizer, Consumer<UIButtonEnum<E>> clickHandler, String id, String ... classes) {
        super(localizer.apply(value), (BiFunction<UIButtonText, MouseButton, Boolean>)null, id, classes);
        this.callback = this::handleClick;
        this.localizer = localizer;
        this.clickHandler = clickHandler;
    }

    public UIButtonEnum(E value, Function<E, String> localizer, String id, String ... classes) {
        this(value, localizer, (Consumer<UIButtonEnum<E>>)null, id, classes);
    }

    public void setValue(E value) {
        this.value = value;
        this.setText(this.localizer.apply(value));
    }

    private boolean handleClick(UIButtonText button, MouseButton mouseButton) {
        if (mouseButton == MouseButton.LEFT) {
            this.setValue(EnumUtils.getNextValue(this.value));
        } else if (mouseButton == MouseButton.RIGHT) {
            this.setValue(EnumUtils.getPreviousValue(this.value));
        }
        if (this.clickHandler != null) {
            this.clickHandler.accept(this);
        }
        return true;
    }

    public E getValue() {
        return this.value;
    }
}

