/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.structure;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.items.IItemHandlerModifiable;

public class Structure
implements IForgeRegistryEntry<Structure> {
    private ResourceLocation registryName;
    private BlockInfo[][][] blocks;
    private EntityInfo[] entities;

    public Structure(World world, AxisAlignedBB box) {
        int xSize = (int)(box.field_72336_d - box.field_72340_a);
        int ySize = (int)(box.field_72337_e - box.field_72338_b);
        int zSize = (int)(box.field_72334_f - box.field_72339_c);
        this.blocks = new BlockInfo[ySize][xSize][zSize];
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    BlockPos pos = new BlockPos(x + (int)box.field_72340_a, y + (int)box.field_72338_b, z + (int)box.field_72339_c);
                    IBlockState state = world.func_180495_p(pos);
                    this.blocks[y][x][z] = new BlockInfo(world, pos, state);
                }
            }
        }
        List entities = world.func_72872_a(Entity.class, box);
        this.entities = new EntityInfo[entities.size()];
        BlockPos structureOrigin = new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c);
        for (int i = 0; i < entities.size(); ++i) {
            this.entities[i] = new EntityInfo((Entity)entities.get(i), structureOrigin);
        }
    }

    public int xSize() {
        return this.blocks[0].length;
    }

    public int ySize() {
        return this.blocks.length;
    }

    public int zSize() {
        return this.blocks[0][0].length;
    }

    public BlockInfo get(int x, int y, int z) {
        return this.blocks[y][x][z];
    }

    public void generate(World world, BlockPos basePos, int flags) {
        for (int x = 0; x < this.xSize(); ++x) {
            for (int y = 0; y < this.ySize(); ++y) {
                for (int z = 0; z < this.zSize(); ++z) {
                    BlockInfo block = this.get(x, y, z);
                    block.load(world, basePos.func_177982_a(x, y, z), flags);
                }
            }
        }
        for (EntityInfo e : this.entities) {
            e.spawn(world, basePos);
        }
    }

    public void generate(World world, BlockPos basePos) {
        this.generate(world, basePos, 3);
    }

    public void generate(ChunkPrimer primer) {
        for (int x = 0; x < this.xSize(); ++x) {
            for (int y = 0; y < this.ySize(); ++y) {
                for (int z = 0; z < this.zSize(); ++z) {
                    BlockInfo block = this.get(x, y, z);
                    primer.func_177855_a(x, y, z, block.createState());
                }
            }
        }
    }

    public Structure setRegistryName(ResourceLocation name) {
        this.registryName = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Class<? super Structure> getRegistryType() {
        return Structure.class;
    }

    public Structure() {
    }

    @ConstructorProperties(value={"registryName", "blocks", "entities"})
    public Structure(ResourceLocation registryName, BlockInfo[][][] blocks, EntityInfo[] entities) {
        this.registryName = registryName;
        this.blocks = blocks;
        this.entities = entities;
    }

    public static class EntityInfo {
        private String id;
        private double[] pos;
        private String spawnHandler;

        public EntityInfo(Entity entity, BlockPos structureOrigin) {
            this.id = EntityList.func_75621_b((Entity)entity);
            this.pos = new double[3];
            this.pos[0] = entity.field_70165_t - (double)structureOrigin.func_177958_n();
            this.pos[1] = entity.field_70163_u - (double)structureOrigin.func_177956_o();
            this.pos[2] = entity.field_70161_v - (double)structureOrigin.func_177952_p();
            this.spawnHandler = "";
        }

        public void spawn(World world, BlockPos structureOrigin) {
            Entity entity = EntityList.func_75620_a((String)this.id, (World)world);
            entity.func_70012_b(this.pos[0] + (double)structureOrigin.func_177958_n(), this.pos[1] + (double)structureOrigin.func_177956_o(), this.pos[2] + (double)structureOrigin.func_177952_p(), 0.0f, 0.0f);
            world.func_72838_d(entity);
            if (this.spawnHandler != null && !this.spawnHandler.isEmpty()) {
                try {
                    Class<?> clazz = Class.forName(this.spawnHandler);
                    if (!Consumer.class.isAssignableFrom(clazz)) {
                        throw new RuntimeException("Invalid entity spawn handler class that wasn't a java.util.function.Consumer");
                    }
                    Method m = clazz.getMethod("accept", Object.class);
                    m.invoke(clazz.newInstance(), entity);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public EntityInfo() {
        }
    }

    public static class InventoryEntry {
        private String item;
        private int amount;
        private int slot;

        public InventoryEntry(ItemStack stack, int slot) {
            this.slot = slot;
            String id = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString();
            int meta = stack.func_77960_j();
            if (meta != 0) {
                id = id + ":" + meta;
            }
            this.item = id;
            this.amount = stack.field_77994_a;
        }

        private ItemStack getStack() {
            String[] bits = this.item.split(":");
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(bits[0], bits[1]));
            int meta = bits.length > 2 ? Integer.parseInt(bits[2]) : 0;
            return new ItemStack(item, this.amount, meta);
        }

        @ConstructorProperties(value={"item", "amount", "slot"})
        public InventoryEntry(String item, int amount, int slot) {
            this.item = item;
            this.amount = amount;
            this.slot = slot;
        }
    }

    public static class BlockInfo {
        private String id;
        private Map<String, String> properties;
        private String lootId = "";
        private InventoryEntry[] inventory = new InventoryEntry[0];

        public BlockInfo(World world, BlockPos pos, IBlockState state) {
            this.id = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString();
            this.properties = new HashMap<String, String>();
            for (IProperty prop : state.func_177227_a()) {
                this.properties.put(prop.func_177701_a(), prop.func_177702_a(state.func_177229_b(prop)));
            }
            this.lootId = "";
            ArrayList<InventoryEntry> inventory = new ArrayList<InventoryEntry>();
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IInventory) {
                IInventory inv = (IInventory)te;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack == null) continue;
                    inventory.add(new InventoryEntry(stack, i));
                }
            } else if (te instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable handler = (IItemHandlerModifiable)te;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack == null) continue;
                    inventory.add(new InventoryEntry(stack, i));
                }
            }
            this.inventory = inventory.toArray(new InventoryEntry[inventory.size()]);
        }

        private void load(World world, BlockPos pos, int flags) {
            block3: {
                TileEntity te;
                block2: {
                    IBlockState state = this.id.isEmpty() ? Blocks.field_150350_a.func_176223_P() : this.createState();
                    world.func_180501_a(pos, state, flags);
                    te = world.func_175625_s(pos);
                    if (!(te instanceof IInventory)) break block2;
                    IInventory inv = (IInventory)te;
                    LootContext context = new LootContext.Builder((WorldServer)world).func_186471_a();
                    LootTable table = world.func_184146_ak().func_186521_a(new ResourceLocation(this.lootId));
                    table.func_186460_a(inv, world.field_73012_v, context);
                    for (InventoryEntry e : this.inventory) {
                        inv.func_70299_a(e.slot, e.getStack());
                    }
                    break block3;
                }
                if (!(te instanceof IItemHandlerModifiable)) break block3;
                IItemHandlerModifiable handler = (IItemHandlerModifiable)te;
                for (InventoryEntry e : this.inventory) {
                    handler.setStackInSlot(e.slot, e.getStack());
                }
            }
        }

        private IBlockState createState() {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(this.id));
            IBlockState state = block.func_176223_P();
            for (Map.Entry<String, String> e : this.properties.entrySet()) {
                IProperty prop = block.func_176194_O().func_177623_d().stream().filter(p -> p.func_177701_a().equals(e.getKey())).findFirst().get();
                state = state.func_177226_a(prop, this.getVal(e.getValue(), prop));
            }
            return state;
        }

        private <T extends Comparable<T>> T getVal(String name, IProperty<T> prop) {
            HashMap valueNameMap = new HashMap();
            prop.func_177700_c().forEach(t -> valueNameMap.put(prop.func_177702_a(t), t));
            return (T)((Comparable)valueNameMap.get(name));
        }

        public BlockInfo() {
        }

        static /* synthetic */ InventoryEntry[] access$702(BlockInfo x0, InventoryEntry[] x1) {
            x0.inventory = x1;
            return x1;
        }

        public static class Serializer
        implements JsonDeserializer<BlockInfo> {
            public BlockInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject obj = json.getAsJsonObject();
                BlockInfo info = new BlockInfo();
                info.id = obj.get("id").getAsString();
                info.properties = new HashMap();
                JsonObject properties = obj.get("properties").getAsJsonObject();
                for (Map.Entry e : properties.entrySet()) {
                    info.properties.put(e.getKey(), ((JsonElement)e.getValue()).getAsString());
                }
                if (obj.has("lootId")) {
                    info.lootId = obj.get("lootId").getAsString();
                }
                if (obj.has("inventory")) {
                    JsonArray array = obj.get("inventory").getAsJsonArray();
                    BlockInfo.access$702(info, new InventoryEntry[array.size()]);
                    for (int i = 0; i < array.size(); ++i) {
                        ((BlockInfo)info).inventory[i] = (InventoryEntry)context.deserialize(array.get(i), InventoryEntry.class);
                    }
                }
                return info;
            }
        }
    }
}

