/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.IConfigurable;
import mekanism.api.Range4D;
import mekanism.api.util.CapabilityUtils;
import mekanism.api.util.StackUtils;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.Tier;
import mekanism.common.base.IActiveState;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.item.ItemBlockBasic;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

@Optional.Interface(iface="powercrystals.minefactoryreloaded.api.IDeepStorageUnit", modid="MineFactoryReloaded")
public class TileEntityBin
extends TileEntityBasicBlock
implements ISidedInventory,
IActiveState,
IDeepStorageUnit,
IConfigurable,
ITierUpgradeable {
    public boolean isActive;
    public boolean clientActive;
    public final int MAX_DELAY = 10;
    public int addTicks = 0;
    public int delayTicks;
    public int cacheCount;
    public Tier.BinTier tier = Tier.BinTier.BASIC;
    public ItemStack itemType;
    public ItemStack topStack;
    public ItemStack bottomStack;
    public int prevCount;
    public int clientAmount;
    private BinItemHandler myItemHandler = new BinItemHandler(this);

    @Override
    public boolean upgrade(Tier.BaseTier upgradeTier) {
        if (upgradeTier.ordinal() != this.tier.ordinal() + 1) {
            return false;
        }
        this.tier = Tier.BinTier.values()[upgradeTier.ordinal()];
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
        this.func_70296_d();
        return true;
    }

    public void sortStacks() {
        if (this.getItemCount() == 0 || this.itemType == null) {
            this.itemType = null;
            this.topStack = null;
            this.bottomStack = null;
            this.cacheCount = 0;
            return;
        }
        int count = this.getItemCount();
        int remain = this.tier.storage - count;
        if (remain >= this.itemType.func_77976_d()) {
            this.topStack = null;
        } else {
            this.topStack = this.itemType.func_77946_l();
            this.topStack.field_77994_a = this.itemType.func_77976_d() - remain;
        }
        this.bottomStack = this.itemType.func_77946_l();
        this.bottomStack.field_77994_a = Math.min(this.itemType.func_77976_d(), count -= StackUtils.getSize(this.topStack));
        this.cacheCount = count -= StackUtils.getSize(this.bottomStack);
    }

    public boolean isValid(ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBlockBasic && stack.func_77952_i() == 6) {
            return false;
        }
        if (this.itemType == null) {
            return true;
        }
        return stack.func_77969_a(this.itemType) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.itemType);
    }

    public ItemStack add(ItemStack stack, boolean simulate) {
        if (this.isValid(stack) && (this.tier == Tier.BinTier.CREATIVE || this.getItemCount() != this.tier.storage)) {
            if (this.itemType == null && !simulate) {
                this.setItemType(stack);
            }
            if (this.tier != Tier.BinTier.CREATIVE) {
                if (this.getItemCount() + stack.field_77994_a <= this.tier.storage) {
                    if (!simulate) {
                        this.setItemCount(this.getItemCount() + stack.field_77994_a);
                    }
                    return null;
                }
                ItemStack rejects = stack.func_77946_l();
                rejects.field_77994_a = this.getItemCount() + stack.field_77994_a - this.tier.storage;
                if (!simulate) {
                    this.setItemCount(this.tier.storage);
                }
                return rejects;
            }
            if (!simulate) {
                this.setItemCount(Integer.MAX_VALUE);
            }
        }
        return stack;
    }

    public ItemStack add(ItemStack stack) {
        return this.add(stack, false);
    }

    public ItemStack removeStack() {
        if (this.getItemCount() == 0) {
            return null;
        }
        return this.remove(this.bottomStack.field_77994_a);
    }

    public ItemStack remove(int amount, boolean simulate) {
        if (this.getItemCount() == 0) {
            return null;
        }
        ItemStack ret = this.itemType.func_77946_l();
        ret.field_77994_a = Math.min(Math.min(amount, this.itemType.func_77976_d()), this.getItemCount());
        if (this.tier != Tier.BinTier.CREATIVE && !simulate) {
            this.setItemCount(this.getItemCount() - ret.field_77994_a);
        }
        return ret;
    }

    public ItemStack remove(int amount) {
        return this.remove(amount, false);
    }

    public int getItemCount() {
        return StackUtils.getSize(this.bottomStack) + this.cacheCount + StackUtils.getSize(this.topStack);
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            this.addTicks = Math.max(0, this.addTicks - 1);
            this.delayTicks = Math.max(0, this.delayTicks - 1);
            this.sortStacks();
            if (this.getItemCount() != this.prevCount) {
                this.func_70296_d();
                MekanismUtils.saveChunk(this);
            }
            if (this.delayTicks == 0) {
                if (this.bottomStack != null && this.isActive) {
                    TileEntity tile = Coord4D.get(this).offset(EnumFacing.DOWN).getTileEntity((IBlockAccess)this.field_145850_b);
                    if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, EnumFacing.UP)) {
                        ILogisticalTransporter transporter = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, EnumFacing.UP);
                        ItemStack rejects = TransporterUtils.insert(this, transporter, this.bottomStack, null, true, 0);
                        if (TransporterManager.didEmit(this.bottomStack, rejects)) {
                            this.func_70299_a(0, rejects);
                        }
                    } else if (tile instanceof IInventory) {
                        this.func_70299_a(0, InventoryUtils.putStackInInventory((IInventory)tile, this.bottomStack, EnumFacing.DOWN, false));
                    }
                    this.delayTicks = 10;
                }
            } else {
                --this.delayTicks;
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("itemCount", this.cacheCount);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        if (this.bottomStack != null) {
            nbtTags.func_74782_a("bottomStack", (NBTBase)this.bottomStack.func_77955_b(new NBTTagCompound()));
        }
        if (this.topStack != null) {
            nbtTags.func_74782_a("topStack", (NBTBase)this.topStack.func_77955_b(new NBTTagCompound()));
        }
        if (this.getItemCount() > 0) {
            nbtTags.func_74782_a("itemType", (NBTBase)this.itemType.func_77955_b(new NBTTagCompound()));
        }
        return nbtTags;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.cacheCount = nbtTags.func_74762_e("itemCount");
        this.tier = Tier.BinTier.values()[nbtTags.func_74762_e("tier")];
        this.bottomStack = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("bottomStack"));
        this.topStack = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("topStack"));
        if (this.getItemCount() > 0) {
            this.itemType = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("itemType"));
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.getItemCount());
        data.add(this.tier.ordinal());
        if (this.getItemCount() > 0) {
            data.add(this.itemType);
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.isActive = dataStream.readBoolean();
            this.clientAmount = dataStream.readInt();
            this.tier = Tier.BinTier.values()[dataStream.readInt()];
            this.itemType = this.clientAmount > 0 ? PacketHandler.readStack(dataStream) : null;
            MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
        }
    }

    public ItemStack func_70301_a(int slotID) {
        if (slotID == 1) {
            return this.topStack;
        }
        return this.bottomStack;
    }

    public ItemStack func_70298_a(int slotID, int amount) {
        int toRemove;
        if (slotID == 1) {
            return null;
        }
        if (slotID == 0 && (toRemove = Math.min(this.getItemCount(), amount)) > 0) {
            ItemStack ret = this.itemType.func_77946_l();
            ret.field_77994_a = toRemove;
            this.setItemCount(this.getItemCount() - toRemove);
            return ret;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotID) {
        return this.func_70301_a(slotID);
    }

    public int func_70302_i_() {
        return 2;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == 0) {
            if (this.getItemCount() == 0) {
                return;
            }
            if (this.tier != Tier.BinTier.CREATIVE) {
                if (itemstack == null) {
                    this.setItemCount(this.getItemCount() - this.bottomStack.field_77994_a);
                } else {
                    this.setItemCount(this.getItemCount() - (this.bottomStack.field_77994_a - itemstack.field_77994_a));
                }
            }
        } else if (i == 1) {
            if (itemstack == null) {
                this.topStack = null;
            } else if (this.isValid(itemstack) && itemstack.field_77994_a > StackUtils.getSize(this.topStack) && this.tier != Tier.BinTier.CREATIVE) {
                this.add(StackUtils.size(itemstack, itemstack.field_77994_a - StackUtils.getSize(this.topStack)));
            }
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            MekanismUtils.saveChunk(this);
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
            this.prevCount = this.getItemCount();
            this.sortStacks();
        }
    }

    public void setItemType(ItemStack stack) {
        if (stack == null) {
            this.itemType = null;
            this.cacheCount = 0;
            this.topStack = null;
            this.bottomStack = null;
            return;
        }
        ItemStack ret = stack.func_77946_l();
        ret.field_77994_a = 1;
        this.itemType = ret;
    }

    public void setItemCount(int count) {
        this.cacheCount = Math.max(0, count);
        this.topStack = null;
        this.bottomStack = null;
        if (count == 0) {
            this.setItemType(null);
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return LangUtils.localize(this.func_145838_q().func_149739_a() + ".Bin" + this.tier.getBaseTier().getSimpleName() + ".name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 1 && this.isValid(itemstack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return new int[]{1};
        }
        if (side == EnumFacing.DOWN) {
            return new int[]{0};
        }
        return InventoryUtils.EMPTY;
    }

    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing side) {
        return i == 0 && this.isValid(itemstack);
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    public ItemStack getStoredItemType() {
        if (this.itemType == null) {
            return null;
        }
        return MekanismUtils.size(this.itemType, this.getItemCount());
    }

    public void setStoredItemCount(int amount) {
        if (amount == 0) {
            this.setStoredItemType(null, 0);
        }
        this.setItemCount(amount);
    }

    public void setStoredItemType(ItemStack type, int amount) {
        this.itemType = type;
        this.cacheCount = amount;
        this.topStack = null;
        this.bottomStack = null;
        this.func_70296_d();
    }

    public int getMaxStoredCount() {
        return this.tier.storage;
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        this.setActive(!this.getActive());
        this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 1.0f);
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        return EnumActionResult.PASS;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.CONFIGURABLE_CAPABILITY) {
            return (T)this;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.myItemHandler;
        }
        return super.getCapability(capability, side);
    }

    private class BinItemHandler
    implements IItemHandler {
        private TileEntityBin tileEntityBin;

        public BinItemHandler(TileEntityBin tileEntityBin2) {
            this.tileEntityBin = tileEntityBin2;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot != 0 || this.tileEntityBin.itemType == null) {
                return null;
            }
            return MekanismUtils.size(this.tileEntityBin.itemType, this.tileEntityBin.getItemCount());
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot != 0) {
                return null;
            }
            return this.tileEntityBin.add(stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0) {
                return null;
            }
            return this.tileEntityBin.remove(amount, simulate);
        }
    }
}

