/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.common.PacketHandler;
import mekanism.common.base.IFluidContainerManager;
import mekanism.common.util.FluidContainerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketContainerEditMode
implements IMessageHandler<ContainerEditModeMessage, IMessage> {
    public IMessage onMessage(final ContainerEditModeMessage message, MessageContext context) {
        final EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(new Runnable(){

            @Override
            public void run() {
                TileEntity tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
                if (tileEntity instanceof IFluidContainerManager) {
                    ((IFluidContainerManager)tileEntity).setContainerEditMode(message.value);
                }
            }
        }, player);
        return null;
    }

    public static class ContainerEditModeMessage
    implements IMessage {
        public Coord4D coord4D;
        public FluidContainerUtils.ContainerEditMode value;

        public ContainerEditModeMessage() {
        }

        public ContainerEditModeMessage(Coord4D coord, FluidContainerUtils.ContainerEditMode mode) {
            this.coord4D = coord;
            this.value = mode;
        }

        public void toBytes(ByteBuf dataStream) {
            this.coord4D.write(dataStream);
            dataStream.writeInt(this.value.ordinal());
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = Coord4D.read(dataStream);
            this.value = FluidContainerUtils.ContainerEditMode.values()[dataStream.readInt()];
        }
    }
}

