/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IPartFactory;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.MultipartRegistry;
import mekanism.common.MekanismBlocks;
import mekanism.common.Tier;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.multipart.PartDiversionTransporter;
import mekanism.common.multipart.PartGlowPanel;
import mekanism.common.multipart.PartLogisticalTransporter;
import mekanism.common.multipart.PartMechanicalPipe;
import mekanism.common.multipart.PartPressurizedTube;
import mekanism.common.multipart.PartRestrictiveTransporter;
import mekanism.common.multipart.PartThermodynamicConductor;
import mekanism.common.multipart.PartUniversalCable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class MultipartMekanism
implements IPartFactory {
    public MultipartMekanism() {
        this.init();
    }

    public void init() {
        MultipartRegistry.registerPartFactory((IPartFactory)this, (String[])new String[]{"mekanism:universal_cable_basic", "mekanism:universal_cable_advanced", "mekanism:universal_cable_elite", "mekanism:universal_cable_ultimate", "mekanism:mechanical_pipe", "mekanism:mechanical_pipe_basic", "mekanism:mechanical_pipe_advanced", "mekanism:mechanical_pipe_elite", "mekanism:mechanical_pipe_ultimate", "mekanism:pressurized_tube_basic", "mekanism:pressurized_tube_advanced", "mekanism:pressurized_tube_elite", "mekanism:pressurized_tube_ultimate", "mekanism:logistical_transporter_basic", "mekanism:logistical_transporter_advanced", "mekanism:logistical_transporter_elite", "mekanism:logistical_transporter_ultimate", "mekanism:restrictive_transporter", "mekanism:diversion_transporter", "mekanism:thermodynamic_conductor_basic", "mekanism:thermodynamic_conductor_advanced", "mekanism:thermodynamic_conductor_elite", "mekanism:thermodynamic_conductor_ultimate", "mekanism:glow_panel"});
        this.registerMicroMaterials();
    }

    public IMultipart createPart(ResourceLocation resource, boolean client2) {
        String name = resource.toString();
        if (name.equals("mekanism:universal_cable")) {
            return new PartUniversalCable(Tier.CableTier.BASIC);
        }
        if (name.equals("mekanism:universal_cable_basic")) {
            return new PartUniversalCable(Tier.CableTier.BASIC);
        }
        if (name.equals("mekanism:universal_cable_advanced")) {
            return new PartUniversalCable(Tier.CableTier.ADVANCED);
        }
        if (name.equals("mekanism:universal_cable_elite")) {
            return new PartUniversalCable(Tier.CableTier.ELITE);
        }
        if (name.equals("mekanism:universal_cable_ultimate")) {
            return new PartUniversalCable(Tier.CableTier.ULTIMATE);
        }
        if (name.equals("mekanism:mechanical_pipe")) {
            return new PartMechanicalPipe(Tier.PipeTier.BASIC);
        }
        if (name.equals("mekanism:mechanical_pipe_basic")) {
            return new PartMechanicalPipe(Tier.PipeTier.BASIC);
        }
        if (name.equals("mekanism:mechanical_pipe_advanced")) {
            return new PartMechanicalPipe(Tier.PipeTier.ADVANCED);
        }
        if (name.equals("mekanism:mechanical_pipe_elite")) {
            return new PartMechanicalPipe(Tier.PipeTier.ELITE);
        }
        if (name.equals("mekanism:mechanical_pipe_ultimate")) {
            return new PartMechanicalPipe(Tier.PipeTier.ULTIMATE);
        }
        if (name.equals("mekanism:pressurized_tube_basic") || name.equals("mekanism:pressurized_tube")) {
            return new PartPressurizedTube(Tier.TubeTier.BASIC);
        }
        if (name.equals("mekanism:pressurized_tube_advanced")) {
            return new PartPressurizedTube(Tier.TubeTier.ADVANCED);
        }
        if (name.equals("mekanism:pressurized_tube_elite")) {
            return new PartPressurizedTube(Tier.TubeTier.ELITE);
        }
        if (name.equals("mekanism:pressurized_tube_ultimate")) {
            return new PartPressurizedTube(Tier.TubeTier.ULTIMATE);
        }
        if (name.equals("mekanism:logistical_transporter_basic") || name.equals("mekanism:logistical_transporter")) {
            return new PartLogisticalTransporter(Tier.TransporterTier.BASIC);
        }
        if (name.equals("mekanism:logistical_transporter_advanced")) {
            return new PartLogisticalTransporter(Tier.TransporterTier.ADVANCED);
        }
        if (name.equals("mekanism:logistical_transporter_elite")) {
            return new PartLogisticalTransporter(Tier.TransporterTier.ELITE);
        }
        if (name.equals("mekanism:logistical_transporter_ultimate")) {
            return new PartLogisticalTransporter(Tier.TransporterTier.ULTIMATE);
        }
        if (name.equals("mekanism:restrictive_transporter")) {
            return new PartRestrictiveTransporter();
        }
        if (name.equals("mekanism:diversion_transporter")) {
            return new PartDiversionTransporter();
        }
        if (name.equals("mekanism:thermodynamic_conductor_basic")) {
            return new PartThermodynamicConductor(Tier.ConductorTier.BASIC);
        }
        if (name.equals("mekanism:thermodynamic_conductor_advanced")) {
            return new PartThermodynamicConductor(Tier.ConductorTier.ADVANCED);
        }
        if (name.equals("mekanism:thermodynamic_conductor_elite")) {
            return new PartThermodynamicConductor(Tier.ConductorTier.ELITE);
        }
        if (name.equals("mekanism:thermodynamic_conductor_ultimate")) {
            return new PartThermodynamicConductor(Tier.ConductorTier.ULTIMATE);
        }
        if (name.equals("mekanism:glow_panel")) {
            return new PartGlowPanel();
        }
        return null;
    }

    public void registerMicroMaterials() {
        for (int i = 0; i < 16; ++i) {
            FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock, 1, i));
            if (!BlockStateMachine.MachineType.get((BlockStateMachine.MachineBlock)BlockStateMachine.MachineBlock.MACHINE_BLOCK_1, (int)i).hasModel) {
                FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.MachineBlock, 1, i));
            }
            if (BlockStateMachine.MachineType.get((BlockStateMachine.MachineBlock)BlockStateMachine.MachineBlock.MACHINE_BLOCK_2, (int)i).hasModel) continue;
            FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.MachineBlock2, 1, i));
        }
        FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock2, 1, 0));
        FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.CardboardBox));
    }

    public static void dropItem(ItemStack stack, Multipart multipart) {
        EntityItem item = new EntityItem(multipart.getWorld(), (double)multipart.getPos().func_177958_n() + 0.5, (double)multipart.getPos().func_177956_o() + 0.5, (double)multipart.getPos().func_177952_p() + 0.5, stack);
        item.field_70159_w = multipart.getWorld().field_73012_v.nextGaussian() * 0.05;
        item.field_70181_x = multipart.getWorld().field_73012_v.nextGaussian() * 0.05 + 0.2;
        item.field_70179_y = multipart.getWorld().field_73012_v.nextGaussian() * 0.05;
        item.func_174869_p();
        multipart.getWorld().func_72838_d((Entity)item);
    }

    public static void dropItems(Multipart multipart) {
        for (ItemStack stack : multipart.getDrops()) {
            MultipartMekanism.dropItem(stack, multipart);
        }
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, EnumFacing side) {
        Vec3d v1 = MultipartMekanism.rotate(new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), side);
        Vec3d v2 = MultipartMekanism.rotate(new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f), side);
        return new AxisAlignedBB(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c);
    }

    public static Vec3d rotate(Vec3d vec, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case UP: {
                return new Vec3d(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
            }
            case NORTH: {
                return new Vec3d(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
            }
            case SOUTH: {
                return new Vec3d(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
            }
            case WEST: {
                return new Vec3d(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
            }
            case EAST: {
                return new Vec3d(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
        }
        return null;
    }
}

