/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import buildcraft.api.tools.IToolWrench;
import java.util.List;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.util.StackUtils;
import mekanism.client.render.ctm.CTMBlockRenderContext;
import mekanism.client.render.ctm.CTMData;
import mekanism.client.render.ctm.ICTMBlock;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.item.ItemBlockBasic;
import mekanism.common.multiblock.IMultiblock;
import mekanism.common.multiblock.IStructuralMultiblock;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionPort;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.TileEntitySuperheatingElement;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockBasic
extends Block
implements ICTMBlock {
    public CTMData[][] ctmData = new CTMData[16][4];

    public BlockBasic() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(20.0f);
        this.func_149647_a(Mekanism.tabMekanism);
        this.initCTMs();
    }

    public static BlockBasic getBlockBasic(final BlockStateBasic.BasicBlock block) {
        return new BlockBasic(){

            @Override
            public BlockStateBasic.BasicBlock getBasicBlock() {
                return block;
            }
        };
    }

    public abstract BlockStateBasic.BasicBlock getBasicBlock();

    public BlockStateContainer func_180661_e() {
        return new BlockStateBasic(this, this.getTypeProperty());
    }

    public IBlockState func_176203_a(int meta) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(this.getBasicBlock(), meta & 0xF);
        return this.func_176223_P().func_177226_a(this.getTypeProperty(), (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        BlockStateBasic.BasicBlockType type = (BlockStateBasic.BasicBlockType)((Object)state.func_177229_b(this.getTypeProperty()));
        return type.meta;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityBasicBlock && ((TileEntityBasicBlock)tile).facing != null) {
            state = state.func_177226_a((IProperty)BlockStateFacing.facingProperty, (Comparable)((TileEntityBasicBlock)tile).facing);
        }
        if (tile instanceof IActiveState) {
            state = state.func_177226_a((IProperty)BlockStateBasic.activeProperty, (Comparable)Boolean.valueOf(((IActiveState)tile).getActive()));
        }
        if (tile instanceof TileEntityInductionCell) {
            state = state.func_177226_a(BlockStateBasic.tierProperty, (Comparable)((Object)((TileEntityInductionCell)tile).tier.getBaseTier()));
        }
        if (tile instanceof TileEntityInductionProvider) {
            state = state.func_177226_a(BlockStateBasic.tierProperty, (Comparable)((Object)((TileEntityInductionProvider)tile).tier.getBaseTier()));
        }
        if (tile instanceof TileEntityBin) {
            state = state.func_177226_a(BlockStateBasic.tierProperty, (Comparable)((Object)((TileEntityBin)tile).tier.getBaseTier()));
        }
        if (tile instanceof TileEntityInductionPort) {
            state = state.func_177226_a((IProperty)BlockStateBasic.activeProperty, (Comparable)Boolean.valueOf(((TileEntityInductionPort)tile).mode));
        }
        if (tile instanceof TileEntitySuperheatingElement) {
            TileEntitySuperheatingElement element = (TileEntitySuperheatingElement)tile;
            boolean active = false;
            if (element.multiblockUUID != null && SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID) != null) {
                active = SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID);
            }
            state = state.func_177226_a((IProperty)BlockStateBasic.activeProperty, (Comparable)Boolean.valueOf(active));
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState stateIn, IBlockAccess w, BlockPos pos) {
        if (stateIn.func_177230_c() == null || stateIn.func_185904_a() == Material.field_151579_a) {
            return stateIn;
        }
        IExtendedBlockState state = (IExtendedBlockState)stateIn;
        CTMBlockRenderContext ctx = new CTMBlockRenderContext(w, pos);
        return state.withProperty((IUnlistedProperty)BlockStateBasic.ctmProperty, (Object)ctx);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = new Coord4D(pos, world).getTileEntity((IBlockAccess)world);
            if (tileEntity instanceof IMultiblock) {
                ((IMultiblock)tileEntity).doUpdate();
            }
            if (tileEntity instanceof TileEntityBasicBlock) {
                ((TileEntityBasicBlock)tileEntity).onNeighborChange(neighborBlock);
            }
            if (tileEntity instanceof IStructuralMultiblock) {
                ((IStructuralMultiblock)tileEntity).doUpdate();
            }
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(this.getBasicBlock(), state.func_177230_c().func_176201_c(state));
        if (type == BlockStateBasic.BasicBlockType.REFINED_OBSIDIAN) {
            return 4000.0f;
        }
        return this.field_149781_w;
    }

    public void initCTMs() {
        switch (this.getBasicBlock()) {
            case BASIC_BLOCK_1: {
                this.ctmData[7][0] = new CTMData(BlockStateBasic.BasicBlockType.TELEPORTER_FRAME, BlockStateMachine.MachineType.TELEPORTER);
                this.ctmData[9][0] = new CTMData(BlockStateBasic.BasicBlockType.DYNAMIC_TANK, BlockStateBasic.BasicBlockType.DYNAMIC_VALVE);
                this.ctmData[10][0] = new CTMData(BlockStateBasic.BasicBlockType.STRUCTURAL_GLASS);
                this.ctmData[11][0] = new CTMData(BlockStateBasic.BasicBlockType.DYNAMIC_TANK, BlockStateBasic.BasicBlockType.DYNAMIC_VALVE);
                this.ctmData[14][0] = new CTMData(BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_BLOCK, BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_VALVE, BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_CONTROLLER);
                this.ctmData[15][0] = new CTMData(BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_BLOCK, BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_VALVE, BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_CONTROLLER);
                break;
            }
            case BASIC_BLOCK_2: {
                this.ctmData[0][0] = new CTMData(BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_BLOCK, BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_VALVE, BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_CONTROLLER);
                this.ctmData[1][0] = new CTMData(BlockStateBasic.BasicBlockType.INDUCTION_CASING, BlockStateBasic.BasicBlockType.INDUCTION_PORT);
                this.ctmData[2][0] = new CTMData(BlockStateBasic.BasicBlockType.INDUCTION_CASING, BlockStateBasic.BasicBlockType.INDUCTION_PORT);
                this.ctmData[3][0] = new CTMData(BlockStateBasic.BasicBlockType.INDUCTION_CELL, BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER).setRenderConvexConnections();
                this.ctmData[3][1] = new CTMData(BlockStateBasic.BasicBlockType.INDUCTION_CELL, BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER).setRenderConvexConnections();
                this.ctmData[3][2] = new CTMData(BlockStateBasic.BasicBlockType.INDUCTION_CELL, BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER).setRenderConvexConnections();
                this.ctmData[3][3] = new CTMData(BlockStateBasic.BasicBlockType.INDUCTION_CELL, BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER).setRenderConvexConnections();
                this.ctmData[4][0] = new CTMData(BlockStateBasic.BasicBlockType.INDUCTION_CELL, BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER).setRenderConvexConnections();
                this.ctmData[4][1] = new CTMData(BlockStateBasic.BasicBlockType.INDUCTION_CELL, BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER).setRenderConvexConnections();
                this.ctmData[4][2] = new CTMData(BlockStateBasic.BasicBlockType.INDUCTION_CELL, BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER).setRenderConvexConnections();
                this.ctmData[4][3] = new CTMData(BlockStateBasic.BasicBlockType.INDUCTION_CELL, BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER).setRenderConvexConnections();
                this.ctmData[5][0] = new CTMData(BlockStateBasic.BasicBlockType.SUPERHEATING_ELEMENT).setRenderConvexConnections();
                this.ctmData[7][0] = new CTMData(BlockStateBasic.BasicBlockType.BOILER_CASING, BlockStateBasic.BasicBlockType.BOILER_VALVE);
                this.ctmData[8][0] = new CTMData(BlockStateBasic.BasicBlockType.BOILER_CASING, BlockStateBasic.BasicBlockType.BOILER_VALVE);
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativetabs, List<ItemStack> list) {
        block3: for (BlockStateBasic.BasicBlockType type : BlockStateBasic.BasicBlockType.values()) {
            if (type.blockType != this.getBasicBlock()) continue;
            switch (type) {
                case INDUCTION_CELL: 
                case INDUCTION_PROVIDER: 
                case BIN: {
                    for (Tier.BaseTier tier : Tier.BaseTier.values()) {
                        if (type != BlockStateBasic.BasicBlockType.BIN && !tier.isObtainable()) continue;
                        ItemStack stack = new ItemStack(item, 1, type.meta);
                        ((ItemBlockBasic)stack.func_77973_b()).setBaseTier(stack, tier);
                        list.add(stack);
                    }
                    continue block3;
                }
                default: {
                    list.add(new ItemStack(item, 1, type.meta));
                }
            }
        }
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        int meta = state.func_177230_c().func_176201_c(state);
        switch (this.getBasicBlock()) {
            case BASIC_BLOCK_1: {
                switch (meta) {
                    case 10: {
                        return false;
                    }
                    case 9: 
                    case 11: {
                        TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)world.func_175625_s(pos);
                        if (tileEntity == null || !(FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? tileEntity.structure != null : tileEntity.clientHasStructure)) break;
                        return false;
                    }
                }
                return super.canCreatureSpawn(state, world, pos, type);
            }
            case BASIC_BLOCK_2: {
                switch (meta) {
                    case 1: 
                    case 2: 
                    case 7: 
                    case 8: {
                        TileEntityMultiblock tileEntity = (TileEntityMultiblock)world.func_175625_s(pos);
                        if (tileEntity == null || !(FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? tileEntity.structure != null : tileEntity.clientHasStructure)) break;
                        return false;
                    }
                }
                return super.canCreatureSpawn(state, world, pos, type);
            }
        }
        return super.canCreatureSpawn(state, world, pos, type);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(world.func_180495_p(pos));
        if (!world.field_72995_K && type == BlockStateBasic.BasicBlockType.BIN) {
            TileEntityBin bin = (TileEntityBin)world.func_175625_s(pos);
            RayTraceResult mop = MekanismUtils.rayTrace(world, player);
            if (mop != null && mop.field_178784_b == bin.facing && bin.bottomStack != null) {
                if (!player.func_70093_af()) {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, bin.removeStack().func_77946_l()));
                } else {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, bin.remove(1).func_77946_l()));
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(state);
        TileEntity tile = world.func_175625_s(pos);
        if (type == BlockStateBasic.BasicBlockType.REFINED_OBSIDIAN && entityplayer.func_70093_af()) {
            entityplayer.openGui((Object)Mekanism.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (tile instanceof TileEntityThermalEvaporationController) {
            if (!entityplayer.func_70093_af()) {
                if (!world.field_72995_K) {
                    entityplayer.openGui((Object)Mekanism.instance, 33, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return true;
            }
        } else if (tile instanceof TileEntitySecurityDesk) {
            String owner = ((TileEntitySecurityDesk)tile).owner;
            if (!entityplayer.func_70093_af()) {
                if (!world.field_72995_K) {
                    if (owner == null || entityplayer.func_70005_c_().equals(owner)) {
                        entityplayer.openGui((Object)Mekanism.instance, 57, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                }
                return true;
            }
        } else {
            if (tile instanceof TileEntityBin) {
                TileEntityBin bin = (TileEntityBin)tile;
                if (stack != null && MekanismUtils.hasUsableWrench(entityplayer, pos)) {
                    if (!world.field_72995_K) {
                        Item tool = stack.func_77973_b();
                        if (entityplayer.func_70093_af()) {
                            this.dismantleBlock(state, world, pos, false);
                            return true;
                        }
                        if (MekanismUtils.isBCWrench(tool)) {
                            ((IToolWrench)tool).wrenchUsed(entityplayer, pos);
                        }
                        int change = bin.facing.func_176746_e().ordinal();
                        bin.setFacing((short)change);
                        world.func_175685_c(pos, (Block)this);
                    }
                    return true;
                }
                if (!world.field_72995_K && bin.getItemCount() < bin.tier.storage) {
                    if (bin.addTicks == 0 && stack != null) {
                        if (stack != null) {
                            ItemStack remain = bin.add(stack);
                            entityplayer.func_184611_a(hand, remain);
                            bin.addTicks = 5;
                        }
                    } else if (bin.addTicks > 0 && bin.getItemCount() > 0) {
                        ItemStack[] inv = entityplayer.field_71071_by.field_70462_a;
                        for (int i = 0; i < inv.length && bin.getItemCount() != bin.tier.storage; ++i) {
                            if (inv[i] != null) {
                                ItemStack remain;
                                inv[i] = remain = bin.add(inv[i]);
                                bin.addTicks = 5;
                            }
                            ((EntityPlayerMP)entityplayer).func_71120_a(entityplayer.field_71070_bA);
                        }
                    }
                }
                return true;
            }
            if (tile instanceof IMultiblock) {
                if (world.field_72995_K) {
                    return true;
                }
                return ((IMultiblock)world.func_175625_s(pos)).onActivate(entityplayer, hand, stack);
            }
            if (tile instanceof IStructuralMultiblock) {
                if (world.field_72995_K) {
                    return true;
                }
                return ((IStructuralMultiblock)world.func_175625_s(pos)).onActivate(entityplayer, hand, stack);
            }
        }
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return BlockStateBasic.BasicBlockType.get(state) != BlockStateBasic.BasicBlockType.STRUCTURAL_GLASS;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public static boolean manageInventory(EntityPlayer player, TileEntityDynamicTank tileEntity, EnumHand hand, ItemStack itemStack) {
        if (tileEntity.structure == null) {
            return false;
        }
        ItemStack copyStack = StackUtils.size(itemStack, 1);
        if (FluidContainerUtils.isFluidContainer(itemStack)) {
            IFluidHandler handler = FluidUtil.getFluidHandler((ItemStack)copyStack);
            if (FluidUtil.getFluidContained((ItemStack)copyStack) == null) {
                int filled;
                if (((SynchronizedTankData)tileEntity.structure).fluidStored != null && (filled = handler.fill(((SynchronizedTankData)tileEntity.structure).fluidStored, !player.field_71075_bZ.field_75098_d)) > 0) {
                    if (player.field_71075_bZ.field_75098_d) {
                        ((SynchronizedTankData)tileEntity.structure).fluidStored.amount -= filled;
                    } else if (itemStack.field_77994_a == 1) {
                        ((SynchronizedTankData)tileEntity.structure).fluidStored.amount -= filled;
                        player.func_184611_a(hand, copyStack);
                    } else if (itemStack.field_77994_a > 1 && player.field_71071_by.func_70441_a(copyStack)) {
                        ((SynchronizedTankData)tileEntity.structure).fluidStored.amount -= filled;
                        --itemStack.field_77994_a;
                    }
                    if (((SynchronizedTankData)tileEntity.structure).fluidStored.amount == 0) {
                        ((SynchronizedTankData)tileEntity.structure).fluidStored = null;
                    }
                    return true;
                }
            } else {
                FluidStack itemFluid = FluidUtil.getFluidContained((ItemStack)copyStack);
                int stored = ((SynchronizedTankData)tileEntity.structure).fluidStored != null ? ((SynchronizedTankData)tileEntity.structure).fluidStored.amount : 0;
                int needed = ((SynchronizedTankData)tileEntity.structure).volume * 64000 - stored;
                if (((SynchronizedTankData)tileEntity.structure).fluidStored != null && !((SynchronizedTankData)tileEntity.structure).fluidStored.isFluidEqual(itemFluid)) {
                    return false;
                }
                boolean filled = false;
                FluidStack drained = handler.drain(needed, !player.field_71075_bZ.field_75098_d);
                if (copyStack.field_77994_a == 0) {
                    copyStack = null;
                }
                if (drained != null) {
                    if (player.field_71075_bZ.field_75098_d) {
                        filled = true;
                    } else if (copyStack != null) {
                        if (itemStack.field_77994_a == 1) {
                            player.func_184611_a(hand, copyStack);
                            filled = true;
                        } else if (player.field_71071_by.func_70441_a(copyStack)) {
                            --itemStack.field_77994_a;
                            filled = true;
                        }
                    } else {
                        --itemStack.field_77994_a;
                        if (itemStack.field_77994_a == 0) {
                            player.func_184611_a(hand, null);
                        }
                        filled = true;
                    }
                    if (filled) {
                        if (((SynchronizedTankData)tileEntity.structure).fluidStored == null) {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored = drained;
                        } else {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored.amount += drained.amount;
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        int metadata = state.func_177230_c().func_176201_c(state);
        if (tileEntity instanceof IActiveState && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).lightUpdate()) {
            return 15;
        }
        if (this.getBasicBlock() == BlockStateBasic.BasicBlock.BASIC_BLOCK_1) {
            switch (metadata) {
                case 2: {
                    return 8;
                }
                case 4: {
                    return 15;
                }
                case 7: {
                    return 12;
                }
            }
        } else if (this.getBasicBlock() == BlockStateBasic.BasicBlock.BASIC_BLOCK_2 && metadata == 5 && tileEntity instanceof TileEntitySuperheatingElement) {
            TileEntitySuperheatingElement element = (TileEntitySuperheatingElement)tileEntity;
            if (element.multiblockUUID != null && SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID) != null) {
                return SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID) != false ? 15 : 0;
            }
            return 0;
        }
        return 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(state);
        return type != null && type.tileEntityClass != null;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (BlockStateBasic.BasicBlockType.get(state) == null) {
            return null;
        }
        return BlockStateBasic.BasicBlockType.get(state).create();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityBasicBlock tileEntity;
        if (world.func_175625_s(pos) instanceof TileEntityBasicBlock) {
            tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
            int side = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int height = Math.round(placer.field_70125_A);
            int change = 3;
            if (tileEntity.canSetFacing(0) && tileEntity.canSetFacing(1)) {
                if (height >= 65) {
                    change = 1;
                } else if (height <= -65) {
                    change = 0;
                }
            }
            if (change != 0 && change != 1) {
                switch (side) {
                    case 0: {
                        change = 2;
                        break;
                    }
                    case 1: {
                        change = 5;
                        break;
                    }
                    case 2: {
                        change = 3;
                        break;
                    }
                    case 3: {
                        change = 4;
                    }
                }
            }
            tileEntity.setFacing((short)change);
            boolean bl = tileEntity.redstone = world.func_175687_A(pos) > 0;
            if (tileEntity instanceof TileEntitySecurityDesk) {
                ((TileEntitySecurityDesk)tileEntity).owner = placer.func_70005_c_();
            }
            if (tileEntity instanceof IBoundingBlock) {
                ((IBoundingBlock)((Object)tileEntity)).onPlace();
            }
        }
        world.func_175704_b(pos, pos.func_177982_a(1, 1, 1));
        world.func_180500_c(EnumSkyBlock.BLOCK, pos);
        world.func_180500_c(EnumSkyBlock.SKY, pos);
        if (!world.field_72995_K && world.func_175625_s(pos) != null) {
            tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof IMultiblock) {
                ((IMultiblock)((Object)tileEntity)).doUpdate();
            }
            if (tileEntity instanceof IStructuralMultiblock) {
                ((IStructuralMultiblock)((Object)tileEntity)).doUpdate();
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)tileEntity).onBreak();
        }
        super.func_180663_b(world, pos, state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityBasicBlock tileEntity;
        BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(state);
        ItemStack ret = new ItemStack((Block)this, 1, state.func_177230_c().func_176201_c(state));
        if (type == BlockStateBasic.BasicBlockType.BIN) {
            tileEntity = (TileEntityBin)world.func_175625_s(pos);
            InventoryBin inv = new InventoryBin(ret);
            ((ITierItem)ret.func_77973_b()).setBaseTier(ret, ((TileEntityBin)tileEntity).tier.getBaseTier());
            inv.setItemCount(((TileEntityBin)tileEntity).getItemCount());
            if (((TileEntityBin)tileEntity).getItemCount() > 0) {
                inv.setItemType(((TileEntityBin)tileEntity).itemType);
            }
        } else if (type == BlockStateBasic.BasicBlockType.INDUCTION_CELL) {
            tileEntity = (TileEntityInductionCell)world.func_175625_s(pos);
            ((ItemBlockBasic)ret.func_77973_b()).setBaseTier(ret, ((TileEntityInductionCell)tileEntity).tier.getBaseTier());
        } else if (type == BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER) {
            tileEntity = (TileEntityInductionProvider)world.func_175625_s(pos);
            ((ItemBlockBasic)ret.func_77973_b()).setBaseTier(ret, ((TileEntityInductionProvider)tileEntity).tier.getBaseTier());
        }
        tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IStrictEnergyStorage) {
            IEnergizedItem energizedItem = (IEnergizedItem)ret.func_77973_b();
            energizedItem.setEnergy(ret, ((IStrictEnergyStorage)((Object)tileEntity)).getEnergy());
        }
        return ret;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return null;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, this.getPickBlock(state, null, world, pos, player));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_175698_g(pos);
    }

    public ItemStack dismantleBlock(IBlockState state, World world, BlockPos pos, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(state, null, world, pos, null);
        world.func_175698_g(pos);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (BlockStateBasic.BasicBlockType.get(state) == BlockStateBasic.BasicBlockType.STRUCTURAL_GLASS && !this.ctmData[10][0].shouldRenderSide(world, pos.func_177972_a(side), side)) {
            return false;
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        EnumFacing[] valid = new EnumFacing[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!basicTile.canSetFacing(dir.ordinal())) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis.ordinal())) {
            basicTile.setFacing((short)axis.ordinal());
            return true;
        }
        return false;
    }

    @Override
    public CTMData getCTMData(IBlockState state) {
        return this.ctmData[state.func_177230_c().func_176201_c(state)][0];
    }

    @Override
    public String getOverrideTexture(IBlockState state, EnumFacing side) {
        BlockStateBasic.BasicBlockType type = (BlockStateBasic.BasicBlockType)((Object)state.func_177229_b(this.getTypeProperty()));
        if (type == BlockStateBasic.BasicBlockType.INDUCTION_CELL || type == BlockStateBasic.BasicBlockType.INDUCTION_PROVIDER) {
            return type.func_176610_l() + "_" + ((Tier.BaseTier)((Object)state.func_177229_b(BlockStateBasic.tierProperty))).func_176610_l();
        }
        if (type == BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_CONTROLLER) {
            if (side == state.func_177229_b((IProperty)BlockStateFacing.facingProperty)) {
                return type.func_176610_l() + ((Boolean)state.func_177229_b((IProperty)BlockStateBasic.activeProperty) != false ? "_on" : "");
            }
            return "thermal_evaporation_block";
        }
        if (type == BlockStateBasic.BasicBlockType.INDUCTION_PORT) {
            return type.func_176610_l() + ((Boolean)state.func_177229_b((IProperty)BlockStateBasic.activeProperty) != false ? "_output" : "");
        }
        return null;
    }

    public PropertyEnum<BlockStateBasic.BasicBlockType> getTypeProperty() {
        return this.getBasicBlock().getProperty();
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return BlockStateBasic.BasicBlockType.get((IBlockState)worldObj.func_180495_p((BlockPos)pos)).isBeaconBase;
    }
}

