/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.MekanismUtils;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class EnergyAcceptorWrapper
implements IStrictEnergyAcceptor {
    public Coord4D coord;

    public static EnergyAcceptorWrapper get(TileEntity tileEntity, EnumFacing side) {
        IEnergyTile tile;
        if (tileEntity == null || tileEntity.func_145831_w() == null) {
            return null;
        }
        EnergyAcceptorWrapper wrapper = null;
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.ENERGY_ACCEPTOR_CAPABILITY, null)) {
            wrapper = new MekanismAcceptor(CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.ENERGY_ACCEPTOR_CAPABILITY, side));
        } else if (MekanismUtils.useTesla() && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.TESLA_CONSUMER_CAPABILITY, side)) {
            wrapper = new TeslaAcceptor(CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.TESLA_CONSUMER_CAPABILITY, side));
        } else if (MekanismUtils.useRF() && tileEntity instanceof IEnergyReceiver) {
            wrapper = new RFAcceptor((IEnergyReceiver)tileEntity);
        } else if (MekanismUtils.useIC2() && (tile = EnergyNet.instance.getSubTile(tileEntity.func_145831_w(), tileEntity.func_174877_v())) instanceof IEnergySink) {
            wrapper = new IC2Acceptor((IEnergySink)tile);
        }
        if (wrapper != null) {
            wrapper.coord = Coord4D.get(tileEntity);
        }
        return wrapper;
    }

    public abstract boolean needsEnergy(EnumFacing var1);

    public static class TeslaAcceptor
    extends EnergyAcceptorWrapper {
        private ITeslaConsumer acceptor;

        public TeslaAcceptor(ITeslaConsumer teslaConsumer) {
            this.acceptor = teslaConsumer;
        }

        @Override
        public double transferEnergyToAcceptor(EnumFacing side, double amount) {
            return this.fromTesla(this.acceptor.givePower(this.toTesla(amount), false));
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.givePower(1L, true) > 0L;
        }

        @Override
        public double getEnergy() {
            return 0.0;
        }

        @Override
        public void setEnergy(double energy) {
        }

        @Override
        public double getMaxEnergy() {
            return 0.0;
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return false;
        }

        public long toTesla(double joules) {
            return Math.round(joules * MekanismConfig.general.TO_TESLA);
        }

        public double fromTesla(double tesla) {
            return tesla * MekanismConfig.general.FROM_TESLA;
        }
    }

    public static class IC2Acceptor
    extends EnergyAcceptorWrapper {
        private IEnergySink acceptor;

        public IC2Acceptor(IEnergySink ic2Acceptor) {
            this.acceptor = ic2Acceptor;
        }

        @Override
        public double transferEnergyToAcceptor(EnumFacing side, double amount) {
            double toTransfer = Math.min(Math.min(this.acceptor.getDemandedEnergy(), this.toEU(amount)), 2.147483647E9);
            double rejects = this.acceptor.injectEnergy(side, toTransfer, 0.0);
            return this.fromEU(toTransfer - rejects);
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.acceptsEnergyFrom(null, side);
        }

        @Override
        public double getEnergy() {
            return 0.0;
        }

        @Override
        public void setEnergy(double energy) {
        }

        @Override
        public double getMaxEnergy() {
            return 0.0;
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.acceptor.getDemandedEnergy() > 0.0;
        }

        public double toEU(double joules) {
            return joules * MekanismConfig.general.TO_IC2;
        }

        public double fromEU(double eu) {
            return eu * MekanismConfig.general.FROM_IC2;
        }
    }

    public static class RFAcceptor
    extends EnergyAcceptorWrapper {
        private IEnergyReceiver acceptor;

        public RFAcceptor(IEnergyReceiver rfAcceptor) {
            this.acceptor = rfAcceptor;
        }

        @Override
        public double transferEnergyToAcceptor(EnumFacing side, double amount) {
            return this.fromRF(this.acceptor.receiveEnergy(side, Math.min(Integer.MAX_VALUE, this.toRF(amount)), false));
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.canConnectEnergy(side);
        }

        @Override
        public double getEnergy() {
            return this.fromRF(this.acceptor.getEnergyStored(null));
        }

        @Override
        public void setEnergy(double energy) {
            int rfToSet = this.toRF(energy);
            int amountToReceive = rfToSet - this.acceptor.getEnergyStored(null);
            this.acceptor.receiveEnergy(null, amountToReceive, false);
        }

        @Override
        public double getMaxEnergy() {
            return this.fromRF(this.acceptor.getMaxEnergyStored(null));
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.acceptor.receiveEnergy(side, 1, true) > 0;
        }

        public int toRF(double joules) {
            return (int)Math.round(joules * MekanismConfig.general.TO_RF);
        }

        public double fromRF(int rf) {
            return (double)rf * MekanismConfig.general.FROM_RF;
        }
    }

    public static class MekanismAcceptor
    extends EnergyAcceptorWrapper {
        private IStrictEnergyAcceptor acceptor;

        public MekanismAcceptor(IStrictEnergyAcceptor mekAcceptor) {
            this.acceptor = mekAcceptor;
        }

        @Override
        public double transferEnergyToAcceptor(EnumFacing side, double amount) {
            return this.acceptor.transferEnergyToAcceptor(side, amount);
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.canReceiveEnergy(side);
        }

        @Override
        public double getEnergy() {
            return this.acceptor.getEnergy();
        }

        @Override
        public void setEnergy(double energy) {
            this.acceptor.setEnergy(energy);
        }

        @Override
        public double getMaxEnergy() {
            return this.acceptor.getMaxEnergy();
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.acceptor.getMaxEnergy() - this.acceptor.getEnergy() > 0.0;
        }
    }
}

