/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.common.ColourRGBA;
import mekanism.common.Mekanism;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.util.LangUtils;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public final class Tier {
    private static List<ITier> tierTypes = new ArrayList<ITier>();
    private static boolean initiated = false;

    public static void init() {
        if (initiated) {
            return;
        }
        for (Class<?> c : Tier.class.getDeclaredClasses()) {
            if (!c.isEnum()) continue;
            try {
                for (Object obj : c.getEnumConstants()) {
                    if (!(obj instanceof ITier)) continue;
                    tierTypes.add((ITier)obj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        initiated = true;
    }

    public static void loadConfig() {
        for (ITier tier : tierTypes) {
            tier.loadConfig();
        }
    }

    public static void readConfig(ByteBuf dataStream) {
        for (ITier tier : tierTypes) {
            tier.readConfig(dataStream);
        }
    }

    public static void writeConfig(ByteBuf dataStream) {
        for (ITier tier : tierTypes) {
            tier.writeConfig(dataStream);
        }
    }

    public static interface ITier {
        public BaseTier getBaseTier();

        public void loadConfig();

        public void readConfig(ByteBuf var1);

        public void writeConfig(ByteBuf var1);
    }

    public static enum BinTier implements ITier
    {
        BASIC(4096),
        ADVANCED(8192),
        ELITE(32768),
        ULTIMATE(262144),
        CREATIVE(Integer.MAX_VALUE);

        public int storage;
        private int baseStorage;

        private BinTier(int s) {
            this.baseStorage = this.storage = s;
        }

        @Override
        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        @Override
        public void loadConfig() {
            this.storage = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "BinStorage", this.baseStorage).getInt();
        }

        @Override
        public void readConfig(ByteBuf dataStream) {
            this.storage = dataStream.readInt();
        }

        @Override
        public void writeConfig(ByteBuf dataStream) {
            dataStream.writeInt(this.storage);
        }
    }

    public static enum GasTankTier implements ITier,
    IStringSerializable
    {
        BASIC(64000, 256),
        ADVANCED(128000, 512),
        ELITE(256000, 1028),
        ULTIMATE(512000, 2056),
        CREATIVE(Integer.MAX_VALUE, Integer.MAX_VALUE);

        public int storage;
        private int baseStorage;
        public int output;
        private int baseOutput;

        private GasTankTier(int s, int o) {
            this.baseStorage = this.storage = s;
            this.baseOutput = this.output = o;
        }

        @Override
        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        @Override
        public void loadConfig() {
            this.storage = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "GasTankStorage", this.baseStorage).getInt();
            this.output = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "GasTankOutput", this.baseOutput).getInt();
        }

        @Override
        public void readConfig(ByteBuf dataStream) {
            this.storage = dataStream.readInt();
            this.output = dataStream.readInt();
        }

        @Override
        public void writeConfig(ByteBuf dataStream) {
            dataStream.writeInt(this.storage);
            dataStream.writeInt(this.output);
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }

    public static enum FluidTankTier implements ITier
    {
        BASIC(14000, 400),
        ADVANCED(28000, 800),
        ELITE(56000, 1600),
        ULTIMATE(112000, 3200),
        CREATIVE(Integer.MAX_VALUE, Integer.MAX_VALUE);

        public int storage;
        private int baseStorage;
        public int output;
        private int baseOutput;

        private FluidTankTier(int s, int o) {
            this.baseStorage = this.storage = s;
            this.baseOutput = this.output = o;
        }

        @Override
        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        @Override
        public void loadConfig() {
            this.storage = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "FluidTankStorage", this.baseStorage).getInt();
            this.output = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "FluidTankOutput", this.baseOutput).getInt();
        }

        @Override
        public void readConfig(ByteBuf dataStream) {
            this.storage = dataStream.readInt();
            this.output = dataStream.readInt();
        }

        @Override
        public void writeConfig(ByteBuf dataStream) {
            dataStream.writeInt(this.storage);
            dataStream.writeInt(this.output);
        }
    }

    public static enum ConductorTier implements ITier
    {
        BASIC(5.0, 1.0, 10.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0), TransmitterType.THERMODYNAMIC_CONDUCTOR_BASIC),
        ADVANCED(5.0, 1.0, 400.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0), TransmitterType.THERMODYNAMIC_CONDUCTOR_ADVANCED),
        ELITE(5.0, 1.0, 8000.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0), TransmitterType.THERMODYNAMIC_CONDUCTOR_ELITE),
        ULTIMATE(5.0, 1.0, 100000.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0), TransmitterType.THERMODYNAMIC_CONDUCTOR_ULTIMATE);

        public double inverseConduction;
        private double baseConduction;
        public double inverseHeatCapacity;
        private double baseHeatCapacity;
        public double inverseConductionInsulation;
        private double baseConductionInsulation;
        public ColourRGBA baseColour;
        public TransmitterType type;

        private ConductorTier(double inversek, double inverseC, double insulationInversek, ColourRGBA colour, TransmitterType transmitterType) {
            this.baseConduction = this.inverseConduction = inversek;
            this.baseHeatCapacity = this.inverseHeatCapacity = inverseC;
            this.baseConductionInsulation = this.inverseConductionInsulation = insulationInversek;
            this.baseColour = colour;
            this.type = transmitterType;
        }

        @Override
        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        @Override
        public void loadConfig() {
            this.inverseConduction = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "ConductorInverseConduction", this.baseConduction).getDouble();
            this.inverseHeatCapacity = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "ConductorHeatCapacity", this.baseHeatCapacity).getDouble();
            this.inverseConductionInsulation = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "ConductorConductionInsulation", this.baseConductionInsulation).getDouble();
        }

        @Override
        public void readConfig(ByteBuf dataStream) {
            this.inverseConduction = dataStream.readDouble();
            this.inverseHeatCapacity = dataStream.readDouble();
            this.inverseConductionInsulation = dataStream.readDouble();
        }

        @Override
        public void writeConfig(ByteBuf dataStream) {
            dataStream.writeDouble(this.inverseConduction);
            dataStream.writeDouble(this.inverseHeatCapacity);
            dataStream.writeDouble(this.inverseConductionInsulation);
        }

        public static ConductorTier get(BaseTier tier) {
            for (ConductorTier transmitter : ConductorTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }
    }

    public static enum TransporterTier implements ITier
    {
        BASIC(1, 5, TransmitterType.LOGISTICAL_TRANSPORTER_BASIC),
        ADVANCED(16, 10, TransmitterType.LOGISTICAL_TRANSPORTER_ADVANCED),
        ELITE(32, 20, TransmitterType.LOGISTICAL_TRANSPORTER_ELITE),
        ULTIMATE(64, 50, TransmitterType.LOGISTICAL_TRANSPORTER_ULTIMATE);

        public int pullAmount;
        private int basePull;
        public int speed;
        private int baseSpeed;
        public TransmitterType type;

        private TransporterTier(int pull, int s, TransmitterType transmitterType) {
            this.basePull = this.pullAmount = pull;
            this.baseSpeed = this.speed = s;
            this.type = transmitterType;
        }

        @Override
        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        @Override
        public void loadConfig() {
            this.pullAmount = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "TransporterPullAmount", this.basePull).getInt();
            this.speed = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "TransporterSpeed", this.baseSpeed).getInt();
        }

        @Override
        public void readConfig(ByteBuf dataStream) {
            this.pullAmount = dataStream.readInt();
            this.speed = dataStream.readInt();
        }

        @Override
        public void writeConfig(ByteBuf dataStream) {
            dataStream.writeInt(this.pullAmount);
            dataStream.writeInt(this.speed);
        }

        public static TransporterTier get(BaseTier tier) {
            for (TransporterTier transmitter : TransporterTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }
    }

    public static enum TubeTier implements ITier
    {
        BASIC(256, 64, TransmitterType.PRESSURIZED_TUBE_BASIC),
        ADVANCED(1024, 256, TransmitterType.PRESSURIZED_TUBE_ADVANCED),
        ELITE(4096, 1024, TransmitterType.PRESSURIZED_TUBE_ELITE),
        ULTIMATE(16384, 4096, TransmitterType.PRESSURIZED_TUBE_ULTIMATE);

        public int tubeCapacity;
        private int baseCapacity;
        public int tubePullAmount;
        private int basePull;
        public TransmitterType type;

        private TubeTier(int capacity, int pullAmount, TransmitterType transmitterType) {
            this.baseCapacity = this.tubeCapacity = capacity;
            this.basePull = this.tubePullAmount = pullAmount;
            this.type = transmitterType;
        }

        @Override
        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        @Override
        public void loadConfig() {
            this.tubeCapacity = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "TubeCapacity", this.baseCapacity).getInt();
            this.tubePullAmount = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "TubePullAmount", this.basePull).getInt();
        }

        @Override
        public void readConfig(ByteBuf dataStream) {
            this.tubeCapacity = dataStream.readInt();
            this.tubePullAmount = dataStream.readInt();
        }

        @Override
        public void writeConfig(ByteBuf dataStream) {
            dataStream.writeInt(this.tubeCapacity);
            dataStream.writeInt(this.tubePullAmount);
        }

        public static TubeTier get(BaseTier tier) {
            for (TubeTier transmitter : TubeTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }
    }

    public static enum PipeTier implements ITier
    {
        BASIC(1000, 100, TransmitterType.MECHANICAL_PIPE_BASIC),
        ADVANCED(4000, 400, TransmitterType.MECHANICAL_PIPE_ADVANCED),
        ELITE(16000, 1600, TransmitterType.MECHANICAL_PIPE_ELITE),
        ULTIMATE(64000, 6400, TransmitterType.MECHANICAL_PIPE_ULTIMATE);

        public int pipeCapacity;
        private int baseCapacity;
        public int pipePullAmount;
        private int basePull;
        public TransmitterType type;

        private PipeTier(int capacity, int pullAmount, TransmitterType transmitterType) {
            this.baseCapacity = this.pipeCapacity = capacity;
            this.basePull = this.pipePullAmount = pullAmount;
            this.type = transmitterType;
        }

        @Override
        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        @Override
        public void loadConfig() {
            this.pipeCapacity = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "PipeCapacity", this.baseCapacity).getInt();
            this.pipePullAmount = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "PipePullAmount", this.basePull).getInt();
        }

        @Override
        public void readConfig(ByteBuf dataStream) {
            this.pipeCapacity = dataStream.readInt();
            this.pipePullAmount = dataStream.readInt();
        }

        @Override
        public void writeConfig(ByteBuf dataStream) {
            dataStream.writeInt(this.pipeCapacity);
            dataStream.writeInt(this.pipePullAmount);
        }

        public static PipeTier get(BaseTier tier) {
            for (PipeTier transmitter : PipeTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }
    }

    public static enum CableTier implements ITier
    {
        BASIC(3200, TransmitterType.UNIVERSAL_CABLE_BASIC),
        ADVANCED(12800, TransmitterType.UNIVERSAL_CABLE_ADVANCED),
        ELITE(64000, TransmitterType.UNIVERSAL_CABLE_ELITE),
        ULTIMATE(320000, TransmitterType.UNIVERSAL_CABLE_ULTIMATE);

        public int cableCapacity;
        private int baseCapacity;
        public TransmitterType type;

        private CableTier(int capacity, TransmitterType transmitterType) {
            this.baseCapacity = this.cableCapacity = capacity;
            this.type = transmitterType;
        }

        @Override
        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        @Override
        public void loadConfig() {
            this.cableCapacity = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "CableCapacity", this.baseCapacity).getInt();
        }

        @Override
        public void readConfig(ByteBuf dataStream) {
            this.cableCapacity = dataStream.readInt();
        }

        @Override
        public void writeConfig(ByteBuf dataStream) {
            dataStream.writeInt(this.cableCapacity);
        }

        public static CableTier get(BaseTier tier) {
            for (CableTier transmitter : CableTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }
    }

    public static enum FactoryTier {
        BASIC(3, new ResourceLocation("mekanism", "gui/factory/GuiBasicFactory.png")),
        ADVANCED(5, new ResourceLocation("mekanism", "gui/factory/GuiAdvancedFactory.png")),
        ELITE(7, new ResourceLocation("mekanism", "gui/factory/GuiEliteFactory.png"));

        public int processes;
        public ResourceLocation guiLocation;

        public static FactoryTier getFromName(String tierName) {
            for (FactoryTier tier : FactoryTier.values()) {
                if (!tierName.contains(tier.getBaseTier().getSimpleName())) continue;
                return tier;
            }
            Mekanism.logger.error("Invalid tier identifier when retrieving with name.");
            return BASIC;
        }

        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        private FactoryTier(int process, ResourceLocation gui) {
            this.processes = process;
            this.guiLocation = gui;
        }
    }

    public static enum InductionProviderTier implements ITier
    {
        BASIC(64000.0),
        ADVANCED(512000.0),
        ELITE(4096000.0),
        ULTIMATE(3.2768E7);

        public double output;
        private double baseOutput;

        private InductionProviderTier(double out) {
            this.baseOutput = this.output = out;
        }

        @Override
        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        @Override
        public void loadConfig() {
            this.output = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "InductionProviderOutput", this.baseOutput).getDouble();
        }

        @Override
        public void readConfig(ByteBuf dataStream) {
            this.output = dataStream.readDouble();
        }

        @Override
        public void writeConfig(ByteBuf dataStream) {
            dataStream.writeDouble(this.output);
        }
    }

    public static enum InductionCellTier implements ITier
    {
        BASIC(1.0E9),
        ADVANCED(8.0E9),
        ELITE(6.4E10),
        ULTIMATE(5.12E11);

        public double maxEnergy;
        private double baseMaxEnergy;

        private InductionCellTier(double max) {
            this.baseMaxEnergy = this.maxEnergy = max;
        }

        @Override
        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        @Override
        public void loadConfig() {
            this.maxEnergy = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "InductionCellMaxEnergy", this.baseMaxEnergy).getDouble();
        }

        @Override
        public void readConfig(ByteBuf dataStream) {
            this.maxEnergy = dataStream.readDouble();
        }

        @Override
        public void writeConfig(ByteBuf dataStream) {
            dataStream.writeDouble(this.maxEnergy);
        }
    }

    public static enum EnergyCubeTier implements ITier,
    IStringSerializable
    {
        BASIC(2000000.0, 800.0),
        ADVANCED(8000000.0, 3200.0),
        ELITE(3.2E7, 12800.0),
        ULTIMATE(1.28E8, 51200.0),
        CREATIVE(Double.MAX_VALUE, Double.MAX_VALUE);

        public double maxEnergy;
        private double baseMaxEnergy;
        public double output;
        private double baseOutput;

        private EnergyCubeTier(double max, double out) {
            this.baseMaxEnergy = this.maxEnergy = max;
            this.baseOutput = this.output = out;
        }

        @Override
        public void loadConfig() {
            if (this != CREATIVE) {
                this.maxEnergy = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "EnergyCubeMaxEnergy", this.baseMaxEnergy).getDouble();
                this.output = Mekanism.configuration.get("tier", this.getBaseTier().getSimpleName() + "EnergyCubeOutput", this.baseOutput).getDouble();
            }
        }

        @Override
        public void readConfig(ByteBuf dataStream) {
            if (this != CREATIVE) {
                this.maxEnergy = dataStream.readDouble();
                this.output = dataStream.readDouble();
            }
        }

        @Override
        public void writeConfig(ByteBuf dataStream) {
            if (this != CREATIVE) {
                dataStream.writeDouble(this.maxEnergy);
                dataStream.writeDouble(this.output);
            }
        }

        @Override
        public BaseTier getBaseTier() {
            return BaseTier.values()[this.ordinal()];
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }

    public static enum BaseTier implements IStringSerializable
    {
        BASIC("Basic", EnumColor.BRIGHT_GREEN),
        ADVANCED("Advanced", EnumColor.DARK_RED),
        ELITE("Elite", EnumColor.DARK_BLUE),
        ULTIMATE("Ultimate", EnumColor.PURPLE),
        CREATIVE("Creative", EnumColor.BLACK);

        private String name;
        private EnumColor color;

        public String getSimpleName() {
            return this.name;
        }

        public String getLocalizedName() {
            return LangUtils.localize("tier." + this.getSimpleName());
        }

        public EnumColor getColor() {
            return this.color;
        }

        public boolean isObtainable() {
            return this != CREATIVE;
        }

        private BaseTier(String s, EnumColor c) {
            this.name = s;
            this.color = c;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

