/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.ctm;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.client.render.ctm.CTMRegistry;
import mekanism.client.render.ctm.TextureCTM;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelCTM
implements IModel {
    private Map<EnumFacing, String> overrides = Maps.newHashMap();
    private transient TextureCTM faceObj;
    private transient Map<EnumFacing, TextureCTM> overridesObj = new EnumMap<EnumFacing, TextureCTM>(EnumFacing.class);
    private transient IBakedModel modelObj;
    private transient List<ResourceLocation> textures = Lists.newArrayList();
    public String modelName;

    public ModelCTM(IBakedModel model, String name) {
        this.modelObj = model;
        this.modelName = name;
    }

    public Collection<ResourceLocation> getDependencies() {
        return new ArrayList<ResourceLocation>();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.copyOf(this.textures);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return null;
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    void load() {
        if (this.faceObj != null) {
            return;
        }
        this.faceObj = CTMRegistry.textureCache.get(this.modelName);
        this.textures.addAll(this.faceObj.getTextures());
        this.overridesObj.values().forEach(t -> this.textures.addAll(t.getTextures()));
    }

    public TextureCTM getDefaultFace() {
        return this.faceObj;
    }

    public TextureCTM getFace(EnumFacing facing) {
        return this.overridesObj.getOrDefault(facing, this.faceObj);
    }

    public IBakedModel getModel(IBlockState state) {
        return this.modelObj;
    }
}

