/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.inventory;

import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class IEInventoryHandler
implements IItemHandlerModifiable {
    int slots;
    IIEInventory inv;
    int slotOffset;
    boolean[] canInsert;
    boolean[] canExtract;

    public IEInventoryHandler(int slots, IIEInventory inventory, int slotOffset, boolean[] canInsert, boolean[] canExtract) {
        this.slots = slots;
        this.inv = inventory;
        this.slotOffset = slotOffset;
        this.canInsert = canInsert;
        this.canExtract = canExtract;
    }

    public IEInventoryHandler(int slots, IIEInventory inventory) {
        this(slots, inventory, 0, new boolean[slots], new boolean[slots]);
        for (int i = 0; i < slots; ++i) {
            this.canInsert[i] = true;
            this.canExtract[i] = true;
        }
    }

    public IEInventoryHandler(int slots, IIEInventory inventory, int slotOffset, boolean canInsert, boolean canExtract) {
        this(slots, inventory, slotOffset, new boolean[slots], new boolean[slots]);
        for (int i = 0; i < slots; ++i) {
            this.canInsert[i] = canInsert;
            this.canExtract[i] = canExtract;
        }
    }

    public int getSlots() {
        return this.slots;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.getInventory()[this.slotOffset + slot];
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.canInsert[slot] || stack == null) {
            return stack;
        }
        if (!this.inv.isStackValid(this.slotOffset + slot, stack = stack.func_77946_l())) {
            return stack;
        }
        int offsetSlot = this.slotOffset + slot;
        ItemStack currentStack = this.inv.getInventory()[offsetSlot];
        if (currentStack == null) {
            int accepted = Math.min(stack.func_77976_d(), this.inv.getSlotLimit(offsetSlot));
            if (accepted < stack.field_77994_a) {
                if (!simulate) {
                    this.inv.getInventory()[offsetSlot] = stack.func_77979_a(accepted);
                    this.inv.doGraphicalUpdates(offsetSlot);
                    return stack;
                }
                stack.field_77994_a -= accepted;
                return stack;
            }
            if (!simulate) {
                this.inv.getInventory()[offsetSlot] = stack;
                this.inv.doGraphicalUpdates(offsetSlot);
            }
            return null;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)currentStack)) {
            return stack;
        }
        int accepted = Math.min(stack.func_77976_d(), this.inv.getSlotLimit(offsetSlot)) - currentStack.field_77994_a;
        if (accepted < stack.field_77994_a) {
            if (!simulate) {
                ItemStack newStack = stack.func_77979_a(accepted);
                newStack.field_77994_a += currentStack.field_77994_a;
                this.inv.getInventory()[offsetSlot] = newStack;
                this.inv.doGraphicalUpdates(offsetSlot);
                return stack;
            }
            stack.field_77994_a -= accepted;
            return stack;
        }
        if (!simulate) {
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a += currentStack.field_77994_a;
            this.inv.getInventory()[offsetSlot] = newStack;
            this.inv.doGraphicalUpdates(offsetSlot);
        }
        return null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.canExtract[slot] || amount == 0) {
            return null;
        }
        int offsetSlot = this.slotOffset + slot;
        ItemStack currentStack = this.inv.getInventory()[offsetSlot];
        if (currentStack == null) {
            return null;
        }
        int extracted = Math.min(currentStack.field_77994_a, amount);
        ItemStack copy = currentStack.func_77946_l();
        copy.field_77994_a = extracted;
        if (!simulate) {
            if (extracted < currentStack.field_77994_a) {
                currentStack.field_77994_a -= extracted;
            } else {
                currentStack = null;
            }
            this.inv.getInventory()[offsetSlot] = currentStack;
            this.inv.doGraphicalUpdates(offsetSlot);
        }
        return copy;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.inv.getInventory()[this.slotOffset + slot] = stack;
        this.inv.doGraphicalUpdates(this.slotOffset + slot);
    }
}

