/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MixerRecipePotion
extends MixerRecipe {
    public final PotionType inputPotionType;

    public MixerRecipePotion(PotionType inputType) {
        super(new FluidStack(IEContent.fluidPotion, 1000), MixerRecipePotion.getFluidStackForType(inputType, 1000), new Object[0], 6400);
        this.inputPotionType = inputType;
    }

    public static FluidStack getFluidStackForType(PotionType type, int amount) {
        if (type == PotionTypes.field_185230_b || type == null) {
            return new FluidStack(FluidRegistry.WATER, amount);
        }
        FluidStack stack = new FluidStack(IEContent.fluidPotion, amount);
        stack.tag = new NBTTagCompound();
        stack.tag.func_74778_a("Potion", ((ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)type)).toString());
        return stack;
    }

    @Override
    public FluidStack getFluidOutput(FluidStack input, ItemStack ... components) {
        if (components.length != 1) {
            return input;
        }
        if (input != null) {
            for (PotionHelper.MixPredicate mixPredicate : PotionHelper.field_185213_a) {
                if (mixPredicate.field_185198_a != this.inputPotionType || !mixPredicate.field_185199_b.apply((Object)components[0])) continue;
                return MixerRecipePotion.getFluidStackForType((PotionType)mixPredicate.field_185200_c, input.amount);
            }
        }
        return input;
    }

    @Override
    public boolean matches(FluidStack fluid, ItemStack ... components) {
        if (fluid != null && fluid.containsFluid(this.fluidInput)) {
            for (PotionHelper.MixPredicate mixPredicate : PotionHelper.field_185213_a) {
                if (mixPredicate.field_185198_a != this.inputPotionType) continue;
                for (ItemStack stack : components) {
                    if (!mixPredicate.field_185199_b.apply((Object)stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int[] getUsedSlots(FluidStack fluid, ItemStack ... components) {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null || !PotionHelper.func_185205_a((ItemStack)components[i])) continue;
            return new int[]{i};
        }
        return new int[0];
    }
}

