/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.util.INBTSerializable;

public class CapabilityShader {
    @CapabilityInject(value=ShaderWrapper.class)
    public static Capability<ShaderWrapper> SHADER_CAPABILITY = null;
    public static IUnlistedProperty<ShaderWrapper> BLOCKSTATE_PROPERTY = new IUnlistedProperty<ShaderWrapper>(){

        public String getName() {
            return "shaderwrapper";
        }

        public boolean isValid(ShaderWrapper value) {
            return true;
        }

        public Class<ShaderWrapper> getType() {
            return ShaderWrapper.class;
        }

        public String valueToString(ShaderWrapper value) {
            return value.toString();
        }
    };

    public static void register() {
        CapabilityManager.INSTANCE.register(ShaderWrapper.class, (Capability.IStorage)new Capability.IStorage<ShaderWrapper>(){

            public NBTBase writeNBT(Capability<ShaderWrapper> capability, ShaderWrapper instance, EnumFacing side) {
                NBTTagCompound nbt = new NBTTagCompound();
                ItemStack shader = instance.getShaderItem();
                if (shader != null) {
                    shader.func_77955_b(nbt);
                } else {
                    nbt.func_74778_a("IE:NoShader", "");
                }
                nbt.func_74778_a("IE:ShaderType", instance.getShaderType());
                return nbt;
            }

            public void readNBT(Capability<ShaderWrapper> capability, ShaderWrapper instance, EnumFacing side, NBTBase nbt) {
                NBTTagCompound tags = (NBTTagCompound)nbt;
                instance.setShaderType(tags.func_74779_i("IE:ShaderType"));
                if (!tags.func_74764_b("IE:NoShader")) {
                    instance.setShaderItem(ItemStack.func_77949_a((NBTTagCompound)tags));
                }
            }
        }, (Callable)new Callable<ShaderWrapper>(){

            @Override
            public ShaderWrapper call() throws Exception {
                return new ShaderWrapper_Direct("");
            }
        });
    }

    public static class ShaderWrapper_Direct
    extends ShaderWrapper
    implements ICapabilityProvider,
    INBTSerializable<NBTTagCompound> {
        protected ItemStack shader;

        public ShaderWrapper_Direct(String type) {
            super(type);
        }

        @Override
        public void setShaderItem(ItemStack shader) {
            this.shader = shader;
        }

        @Override
        @Nullable
        public ItemStack getShaderItem() {
            return this.shader;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == SHADER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == SHADER_CAPABILITY) {
                return (T)this;
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            ItemStack shader = this.getShaderItem();
            if (shader != null) {
                shader.func_77955_b(nbt);
            } else {
                nbt.func_74778_a("IE:NoShader", "");
            }
            nbt.func_74778_a("IE:ShaderType", this.getShaderType());
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            NBTTagCompound tags = nbt;
            this.setShaderType(tags.func_74779_i("IE:ShaderType"));
            if (!tags.func_74764_b("IE:NoShader")) {
                this.setShaderItem(ItemStack.func_77949_a((NBTTagCompound)tags));
            }
        }
    }

    public static class ShaderWrapper_Item
    extends ShaderWrapper {
        public static final String SHADER_NBT_KEY = "IE:Shader";
        protected final ItemStack container;

        public ShaderWrapper_Item(String type, ItemStack container) {
            super(type);
            this.container = container;
        }

        @Override
        public void setShaderItem(ItemStack shader) {
            if (!this.container.func_77942_o()) {
                this.container.func_77982_d(new NBTTagCompound());
            }
            if (shader != null) {
                NBTTagCompound shaderTag = shader.func_77955_b(new NBTTagCompound());
                this.container.func_77978_p().func_74782_a(SHADER_NBT_KEY, (NBTBase)shaderTag);
            } else {
                this.container.func_77978_p().func_82580_o(SHADER_NBT_KEY);
            }
        }

        @Override
        @Nullable
        public ItemStack getShaderItem() {
            NBTTagCompound tagCompound = this.container.func_77978_p();
            if (tagCompound == null || !tagCompound.func_74764_b(SHADER_NBT_KEY)) {
                return null;
            }
            return ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l(SHADER_NBT_KEY));
        }
    }

    public static abstract class ShaderWrapper {
        protected String shaderType;

        public ShaderWrapper(String type) {
            this.shaderType = type;
        }

        public void setShaderType(String shaderType) {
            this.shaderType = shaderType;
        }

        public String getShaderType() {
            return this.shaderType;
        }

        public abstract void setShaderItem(ItemStack var1);

        public abstract ItemStack getShaderItem();
    }
}

