/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class MetalPressRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final IngredientStack input;
    public final ComparableItemStack mold;
    public final ItemStack output;
    public static ArrayListMultimap<ComparableItemStack, MetalPressRecipe> recipeList = ArrayListMultimap.create();

    public MetalPressRecipe(ItemStack output, Object input, ItemStack mold, int energy) {
        this.output = output;
        this.input = ApiUtils.createIngredientStack(input);
        this.mold = ApiUtils.createComparableItemStack(mold);
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor(120.0f * timeModifier);
        this.inputList = Lists.newArrayList((Object[])new IngredientStack[]{this.input});
        this.outputList = Lists.newArrayList((Object[])new ItemStack[]{this.output});
    }

    public MetalPressRecipe setInputSize(int size) {
        this.input.inputSize = size;
        return this;
    }

    @Override
    public void setupJEI() {
        super.setupJEI();
        this.jeiItemInputList = new ArrayList[2];
        this.jeiItemInputList[0] = Lists.newArrayList((Iterable)this.jeiTotalItemInputList);
        this.jeiItemInputList[1] = Lists.newArrayList((Object[])new ItemStack[]{this.mold.stack});
        this.jeiTotalItemInputList.add(this.mold.stack);
    }

    public static MetalPressRecipe addRecipe(ItemStack output, Object input, ItemStack mold, int energy) {
        MetalPressRecipe r = new MetalPressRecipe(output, input, mold, energy);
        recipeList.put((Object)r.mold, (Object)r);
        return r;
    }

    public static MetalPressRecipe findRecipe(ItemStack mold, ItemStack input, boolean checkStackSize) {
        if (mold == null || input == null) {
            return null;
        }
        ComparableItemStack comp = ApiUtils.createComparableItemStack(mold);
        List list = recipeList.get((Object)comp);
        for (MetalPressRecipe recipe : list) {
            if (!recipe.input.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    public static List<MetalPressRecipe> removeRecipes(ItemStack output) {
        ArrayList<MetalPressRecipe> list = new ArrayList<MetalPressRecipe>();
        for (ComparableItemStack mold : recipeList.keySet()) {
            Iterator it = recipeList.get((Object)mold).iterator();
            while (it.hasNext()) {
                MetalPressRecipe ir = (MetalPressRecipe)it.next();
                if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)output, (boolean)true)) continue;
                list.add(ir);
                it.remove();
            }
        }
        return list;
    }

    public static boolean isValidMold(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return recipeList.containsKey((Object)ApiUtils.createComparableItemStack(itemStack));
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("mold", (NBTBase)this.mold.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static MetalPressRecipe loadFromNBT(NBTTagCompound nbt) {
        IngredientStack input = IngredientStack.readFromNBT(nbt.func_74775_l("input"));
        ComparableItemStack mold = ComparableItemStack.readFromNBT(nbt.func_74775_l("mold"));
        List list = recipeList.get((Object)mold);
        for (MetalPressRecipe recipe : list) {
            if (!recipe.input.equals(input)) continue;
            return recipe;
        }
        return null;
    }
}

