/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class BottlingMachineRecipe
extends MultiblockRecipe {
    public final IngredientStack input;
    public final FluidStack fluidInput;
    public final ItemStack output;
    public static ArrayList<BottlingMachineRecipe> recipeList = new ArrayList();

    public BottlingMachineRecipe(ItemStack output, Object input, FluidStack fluidInput) {
        this.output = output;
        this.input = ApiUtils.createIngredientStack(input);
        this.fluidInput = fluidInput;
        this.inputList = Lists.newArrayList((Object[])new IngredientStack[]{this.input});
        this.fluidInputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidInput});
        this.outputList = Lists.newArrayList((Object[])new ItemStack[]{this.output});
    }

    public static void addRecipe(ItemStack output, Object input, FluidStack fluidInput) {
        BottlingMachineRecipe recipe = new BottlingMachineRecipe(output, input, fluidInput);
        if (recipe.input != null) {
            recipeList.add(recipe);
        }
    }

    public static BottlingMachineRecipe findRecipe(ItemStack input, FluidStack fluid) {
        if (input != null && fluid != null) {
            for (BottlingMachineRecipe recipe : recipeList) {
                if (!ApiUtils.stackMatchesObject(input, recipe.input) || !fluid.containsFluid(recipe.fluidInput)) continue;
                return recipe;
            }
        }
        return null;
    }

    public static List<BottlingMachineRecipe> removeRecipes(ItemStack stack) {
        ArrayList<BottlingMachineRecipe> list = new ArrayList<BottlingMachineRecipe>();
        Iterator<BottlingMachineRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            BottlingMachineRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static BottlingMachineRecipe loadFromNBT(NBTTagCompound nbt) {
        IngredientStack input = IngredientStack.readFromNBT(nbt.func_74775_l("input"));
        for (BottlingMachineRecipe recipe : recipeList) {
            if (!recipe.input.equals(input)) continue;
            return recipe;
        }
        return null;
    }
}

