/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.tileentity.TileEntityFacingBase;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.common.helpers.CraftHelper;

public abstract class TileEntityTypeBase
extends TileEntityFacingBase {
    protected CraftHelper.MaterialId texture1;
    protected CraftHelper.MaterialId texture2;
    protected ItemStack resource1;
    protected ItemStack resource2;
    public boolean rayTracing = false;
    public int traceBlock = 0;

    protected boolean isFacingValid(EnumFacing facing) {
        return facing != null && facing.func_176740_k() != EnumFacing.Axis.Y;
    }

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74778_a("texture1", this.getTexture(this.texture1));
        nbtTag.func_74778_a("texture2", this.getTexture(this.texture2));
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.setTextures(nbtTag.func_74779_i("texture1"), nbtTag.func_74779_i("texture2"));
    }

    public String[] getTextures() {
        return new String[]{this.getTexture(this.texture1), this.getTexture(this.texture2)};
    }

    public int getTint(int index) {
        return index == 1 || index == 2 ? Platforms.proxy.getTint(index == 1 ? this.resource1 : this.resource2) : -1;
    }

    protected String getTexture(CraftHelper.MaterialId id) {
        return id == null ? "" : id.toString();
    }

    public void setTextures(String mId1, String mId2) {
        this.texture1 = CraftHelper.MaterialId.getFor(mId1);
        this.texture2 = CraftHelper.MaterialId.getFor(mId2);
        this.resource1 = this.texture1.toStack();
        this.resource2 = this.texture2.toStack();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b((double)0.55f, (double)0.55f, (double)0.55f);
    }
}

