/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.lib.network.ClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PacketListToClient;
import mcjty.lib.varia.Logging;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.typed.Type;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTankFluidsReady
extends PacketListToClient<FluidStack> {
    public PacketTankFluidsReady() {
    }

    public PacketTankFluidsReady(BlockPos pos, String command, List<FluidStack> list) {
        super(pos, command, list);
    }

    protected FluidStack createItem(ByteBuf buf) {
        FluidStack fluidStack = null;
        if (buf.readBoolean()) {
            fluidStack = NetworkTools.readFluidStack((ByteBuf)buf);
        }
        return fluidStack;
    }

    protected void writeItemToBuf(ByteBuf buf, FluidStack item) {
        if (item == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            NetworkTools.writeFluidStack((ByteBuf)buf, (FluidStack)item);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketTankFluidsReady, IMessage> {
        public IMessage onMessage(PacketTankFluidsReady message, MessageContext ctx) {
            RFToolsControl.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketTankFluidsReady message, MessageContext ctx) {
            TileEntity te = RFToolsControl.proxy.getClientWorld().func_175625_s(message.pos);
            if (!(te instanceof ClientCommandHandler)) {
                Logging.log((String)"TileEntity is not a ClientCommandHandler!");
                return;
            }
            ClientCommandHandler clientCommandHandler = (ClientCommandHandler)te;
            if (!clientCommandHandler.execute(message.command, message.list, Type.create(FluidStack.class))) {
                Logging.log((String)("Command " + message.command + " was not handled!"));
            }
        }
    }
}

