/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.network.NetworkTools;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.blocks.processor.ProcessorTileEntity;
import mcjty.rftoolscontrol.blocks.vectorart.GfxOp;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGraphicsReady
implements IMessage {
    private BlockPos pos;
    private Map<String, GfxOp> gfxOps;
    private List<String> orderedOps;

    public void fromBytes(ByteBuf buf) {
        String key;
        int i;
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        int size = buf.readInt();
        this.gfxOps = new HashMap<String, GfxOp>(size);
        for (i = 0; i < size; ++i) {
            key = NetworkTools.readString((ByteBuf)buf);
            GfxOp gfxOp = GfxOp.readFromBuf(buf);
            this.gfxOps.put(key, gfxOp);
        }
        size = buf.readInt();
        this.orderedOps = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            key = NetworkTools.readString((ByteBuf)buf);
            this.orderedOps.add(key);
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeInt(this.gfxOps.size());
        for (Map.Entry<String, GfxOp> entry : this.gfxOps.entrySet()) {
            NetworkTools.writeString((ByteBuf)buf, (String)entry.getKey());
            entry.getValue().writeToBuf(buf);
        }
        buf.writeInt(this.orderedOps.size());
        for (String op : this.orderedOps) {
            NetworkTools.writeString((ByteBuf)buf, (String)op);
        }
    }

    public PacketGraphicsReady() {
    }

    public PacketGraphicsReady(ProcessorTileEntity processor) {
        this.pos = processor.func_174877_v();
        this.gfxOps = processor.getGfxOps();
        this.orderedOps = processor.getOrderedOps();
    }

    public static class Handler
    implements IMessageHandler<PacketGraphicsReady, IMessage> {
        public IMessage onMessage(PacketGraphicsReady message, MessageContext ctx) {
            RFToolsControl.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGraphicsReady message, MessageContext ctx) {
            TileEntity te = RFToolsControl.proxy.getClientWorld().func_175625_s(message.pos);
            if (te instanceof ProcessorTileEntity) {
                ProcessorTileEntity processor = (ProcessorTileEntity)te;
                processor.setClientOrderedGfx(message.gfxOps, message.orderedOps);
            }
        }
    }
}

