/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.items.craftingcard;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tools.ItemStackList;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.tools.MinecraftTools;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.items.craftingcard.CraftingCardContainer;
import mcjty.rftoolscontrol.items.craftingcard.CraftingCardItem;
import mcjty.rftoolscontrol.network.PacketItemNBTToServer;
import mcjty.rftoolscontrol.network.PacketTestRecipe;
import mcjty.rftoolscontrol.network.RFToolsCtrlMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCraftingCard
extends GenericGuiContainer {
    public static final int WIDTH = 180;
    public static final int HEIGHT = 198;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolscontrol", "textures/gui/craftingcard.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftoolscontrol", "textures/gui/guielements.png");
    private BlockRender[] slots = new BlockRender[21];

    public GuiCraftingCard(CraftingCardContainer container) {
        super((ModBase)RFToolsControl.instance, RFToolsCtrlMessages.INSTANCE, null, (Container)container, RFToolsControl.GUI_MANUAL_CONTROL, "craftingcard");
        this.field_146999_f = 180;
        this.field_147000_g = 198;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(iconLocation);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Regular 3x3 crafting recipe").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 4, 160, 14)));
        toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("or more complicated recipes").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 17, 160, 14)));
        toplevel.addChild((Widget)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Update")).setTooltips(new String[]{"Update the item in the output", "slot to the recipe in the", "3x3 grid"})).addButtonEvent(parent -> RFToolsCtrlMessages.INSTANCE.sendToServer((IMessage)new PacketTestRecipe())).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(110, 57, 60, 14)));
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 5; ++x) {
                int idx = y * 5 + x;
                this.createDummySlot(toplevel, idx, new PositionalLayout.PositionalHint(x * 18 + 10, y * 18 + 37, 18, 18), this.createSelectionEvent(idx));
            }
        }
        this.createDummySlot(toplevel, 20, new PositionalLayout.PositionalHint(154, 37, 18, 18), this.createSelectionEvent(20));
        this.updateSlots();
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void createDummySlot(Panel toplevel, final int idx, PositionalLayout.PositionalHint hint, BlockRenderEvent selectionEvent) {
        this.slots[idx] = (BlockRender)new BlockRender(this.field_146297_k, (Gui)this){

            public List<String> getTooltips() {
                Object s = GuiCraftingCard.this.slots[idx].getRenderItem();
                if (s instanceof ItemStack) {
                    ItemStack stack = (ItemStack)s;
                    List list = stack.func_82840_a((EntityPlayer)MinecraftTools.getPlayer((Minecraft)this.mc), this.mc.field_71474_y.field_82882_x);
                    for (int i = 0; i < list.size(); ++i) {
                        if (i == 0) {
                            list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                            continue;
                        }
                        list.set(i, TextFormatting.GRAY + (String)list.get(i));
                    }
                    return list;
                }
                return Collections.emptyList();
            }
        }.setHilightOnHover(true).setLayoutHint((LayoutHint)hint);
        this.slots[idx].addSelectionEvent(selectionEvent);
        toplevel.addChild((Widget)this.slots[idx]);
    }

    private void updateSlots() {
        ItemStackList stacks = this.getStacks();
        if (stacks.isEmpty()) {
            return;
        }
        for (int i = 0; i < stacks.size(); ++i) {
            this.slots[i].setRenderItem(stacks.get(i));
        }
    }

    @Nonnull
    private ItemStackList getStacks() {
        ItemStack cardItem = MinecraftTools.getPlayer((Minecraft)this.field_146297_k).func_184586_b(EnumHand.MAIN_HAND);
        ItemStackList stacks = ItemStackList.EMPTY;
        if (ItemStackTools.isValid((ItemStack)cardItem) && cardItem.func_77973_b() instanceof CraftingCardItem) {
            stacks = CraftingCardItem.getStacksFromItem(cardItem);
        }
        return stacks;
    }

    private BlockRenderEvent createSelectionEvent(final int idx) {
        return new BlockRenderEvent(){

            public void select(Widget parent) {
                ItemStack itemstack = MinecraftTools.getPlayer((Minecraft)GuiCraftingCard.this.field_146297_k).field_71071_by.func_70445_o();
                GuiCraftingCard.this.slots[idx].setRenderItem((Object)itemstack);
                ItemStackList stacks = GuiCraftingCard.this.getStacks();
                if (!stacks.isEmpty()) {
                    stacks.set(idx, (Object)itemstack);
                    ItemStack cardItem = MinecraftTools.getPlayer((Minecraft)GuiCraftingCard.this.field_146297_k).func_184586_b(EnumHand.MAIN_HAND);
                    CraftingCardItem.putStacksInItem(cardItem, stacks);
                    RFToolsCtrlMessages.INSTANCE.sendToServer((IMessage)new PacketItemNBTToServer(cardItem.func_77978_p()));
                }
            }

            public void doubleClick(Widget parent) {
            }
        };
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.updateSlots();
        this.drawWindow();
    }
}

