/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.playerprops;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.RFTools;
import mcjty.rftools.playerprops.SendBuffsToClientHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSendBuffsToClient
implements IMessage {
    private List<PlayerBuff> buffs;

    public void fromBytes(ByteBuf buf) {
        int size = buf.readByte();
        this.buffs = new ArrayList<PlayerBuff>(size);
        for (int i = 0; i < size; ++i) {
            this.buffs.add(PlayerBuff.values()[buf.readByte()]);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.buffs.size());
        for (PlayerBuff buff : this.buffs) {
            buf.writeByte(buff.ordinal());
        }
    }

    public PacketSendBuffsToClient() {
        this.buffs = null;
    }

    public PacketSendBuffsToClient(Map<PlayerBuff, Integer> buffs) {
        this.buffs = new ArrayList<PlayerBuff>(buffs.keySet());
    }

    public List<PlayerBuff> getBuffs() {
        return this.buffs;
    }

    public static class Handler
    implements IMessageHandler<PacketSendBuffsToClient, IMessage> {
        public IMessage onMessage(PacketSendBuffsToClient message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSendBuffsToClient message, MessageContext ctx) {
            SendBuffsToClientHelper.setBuffs(message);
        }
    }
}

