/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.IInventoryWrapper;
import appeng.util.inv.ItemSlot;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class AdaptorIInventory
extends InventoryAdaptor {
    private final IInventory i;
    private final boolean wrapperEnabled;

    public AdaptorIInventory(IInventory s) {
        this.i = s;
        this.wrapperEnabled = s instanceof IInventoryWrapper;
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        int s = this.i.func_70302_i_();
        ItemStack rv = null;
        for (int x = 0; x < s && amount > 0; ++x) {
            ItemStack is = this.i.func_70301_a(x);
            if (is == null || !this.canRemoveStackFromSlot(x, is) || filter != null && !Platform.itemComparisons().isSameItem(is, filter)) continue;
            int boundAmounts = amount;
            if (boundAmounts > is.field_77994_a) {
                boundAmounts = is.field_77994_a;
            }
            if (destination != null && !destination.canInsert(is)) {
                boundAmounts = 0;
            }
            if (boundAmounts <= 0) continue;
            if (rv == null) {
                filter = rv = is.func_77946_l();
                rv.field_77994_a = boundAmounts;
                amount -= boundAmounts;
            } else {
                rv.field_77994_a += boundAmounts;
                amount -= boundAmounts;
            }
            if (is.field_77994_a == boundAmounts) {
                this.i.func_70299_a(x, null);
                this.i.func_70296_d();
                continue;
            }
            ItemStack po = is.func_77946_l();
            po.field_77994_a -= boundAmounts;
            this.i.func_70299_a(x, po);
            this.i.func_70296_d();
        }
        return rv;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        int s = this.i.func_70302_i_();
        ItemStack rv = null;
        for (int x = 0; x < s && amount > 0; ++x) {
            ItemStack is = this.i.func_70301_a(x);
            if (is == null || !this.canRemoveStackFromSlot(x, is) || filter != null && !Platform.itemComparisons().isSameItem(is, filter)) continue;
            int boundAmount = amount;
            if (boundAmount > is.field_77994_a) {
                boundAmount = is.field_77994_a;
            }
            if (destination != null && !destination.canInsert(is)) {
                boundAmount = 0;
            }
            if (boundAmount <= 0) continue;
            if (rv == null) {
                rv = is.func_77946_l();
                rv.field_77994_a = boundAmount;
                amount -= boundAmount;
                continue;
            }
            rv.field_77994_a += boundAmount;
            amount -= boundAmount;
        }
        return rv;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int s = this.i.func_70302_i_();
        for (int x = 0; x < s; ++x) {
            ItemStack is = this.i.func_70301_a(x);
            if (is == null || !this.canRemoveStackFromSlot(x, is) || filter != null && !Platform.itemComparisons().isFuzzyEqualItem(is, filter, fuzzyMode)) continue;
            int newAmount = amount;
            if (newAmount > is.field_77994_a) {
                newAmount = is.field_77994_a;
            }
            if (destination != null && !destination.canInsert(is)) {
                newAmount = 0;
            }
            ItemStack rv = null;
            if (newAmount > 0) {
                rv = is.func_77946_l();
                rv.field_77994_a = newAmount;
                if (is.field_77994_a == rv.field_77994_a) {
                    this.i.func_70299_a(x, null);
                    this.i.func_70296_d();
                } else {
                    ItemStack po = is.func_77946_l();
                    po.field_77994_a -= rv.field_77994_a;
                    this.i.func_70299_a(x, po);
                    this.i.func_70296_d();
                }
            }
            if (rv == null) continue;
            return rv;
        }
        return null;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int s = this.i.func_70302_i_();
        for (int x = 0; x < s; ++x) {
            ItemStack is = this.i.func_70301_a(x);
            if (is == null || !this.canRemoveStackFromSlot(x, is) || filter != null && !Platform.itemComparisons().isFuzzyEqualItem(is, filter, fuzzyMode)) continue;
            int boundAmount = amount;
            if (boundAmount > is.field_77994_a) {
                boundAmount = is.field_77994_a;
            }
            if (destination != null && !destination.canInsert(is)) {
                boundAmount = 0;
            }
            if (boundAmount <= 0) continue;
            ItemStack rv = is.func_77946_l();
            rv.field_77994_a = boundAmount;
            return rv;
        }
        return null;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        return this.addItems(toBeAdded, true);
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return this.addItems(toBeSimulated, false);
    }

    @Override
    public boolean containsItems() {
        int s = this.i.func_70302_i_();
        for (int x = 0; x < s; ++x) {
            if (this.i.func_70301_a(x) == null) continue;
            return true;
        }
        return false;
    }

    private ItemStack addItems(ItemStack itemsToAdd, boolean modulate) {
        if (itemsToAdd == null || itemsToAdd.field_77994_a == 0) {
            return null;
        }
        ItemStack left = itemsToAdd.func_77946_l();
        int stackLimit = itemsToAdd.func_77976_d();
        int perOperationLimit = Math.min(this.i.func_70297_j_(), stackLimit);
        int inventorySize = this.i.func_70302_i_();
        for (int slot = 0; slot < inventorySize; ++slot) {
            ItemStack next = left.func_77946_l();
            next.field_77994_a = Math.min(perOperationLimit, next.field_77994_a);
            if (!this.i.func_94041_b(slot, next)) continue;
            ItemStack is = this.i.func_70301_a(slot);
            if (is == null) {
                left.field_77994_a -= next.field_77994_a;
                if (modulate) {
                    this.i.func_70299_a(slot, next);
                    this.i.func_70296_d();
                }
                if (left.field_77994_a > 0) continue;
                return null;
            }
            if (!Platform.itemComparisons().isSameItem(is, left) || is.field_77994_a >= perOperationLimit) continue;
            int room = perOperationLimit - is.field_77994_a;
            int used = Math.min(left.field_77994_a, room);
            if (modulate) {
                is.field_77994_a += used;
                this.i.func_70299_a(slot, is);
                this.i.func_70296_d();
            }
            left.field_77994_a -= used;
            if (left.field_77994_a > 0) continue;
            return null;
        }
        return left;
    }

    private boolean canRemoveStackFromSlot(int x, ItemStack is) {
        if (this.wrapperEnabled) {
            return ((IInventoryWrapper)this.i).canRemoveItemFromSlot(x, is);
        }
        return true;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new InvIterator();
    }

    private class InvIterator
    implements Iterator<ItemSlot> {
        private final ItemSlot is = new ItemSlot();
        private int x = 0;

        private InvIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.x < AdaptorIInventory.this.i.func_70302_i_();
        }

        @Override
        public ItemSlot next() {
            ItemStack iss = AdaptorIInventory.this.i.func_70301_a(this.x);
            this.is.setExtractable(AdaptorIInventory.this.canRemoveStackFromSlot(this.x, iss));
            this.is.setItemStack(iss);
            this.is.setSlot(this.x);
            ++this.x;
            return this.is;
        }

        @Override
        public void remove() {
        }
    }
}

