/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.HoverChecker;

class CondenserOutputWrapper
extends BlankRecipeWrapper {
    private final ItemStack outputItem;
    private final CondenserOutput condenserOutput;
    private final HoverChecker buttonHoverChecker;
    private final IDrawable buttonIcon;

    CondenserOutputWrapper(CondenserOutput condenserOutput, ItemStack outputItem, IDrawable buttonIcon) {
        this.condenserOutput = condenserOutput;
        this.outputItem = outputItem;
        this.buttonIcon = buttonIcon;
        this.buttonHoverChecker = new HoverChecker(28, 44, 78, 94, 0);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutput(ItemStack.class, (Object)this.outputItem);
    }

    public CondenserOutput getCondenserOutput() {
        return this.condenserOutput;
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.buttonHoverChecker.checkHover(mouseX, mouseY)) {
            String key;
            switch (this.condenserOutput) {
                case MATTER_BALLS: {
                    key = "gui.tooltips.appliedenergistics2.MatterBalls";
                    break;
                }
                case SINGULARITY: {
                    key = "gui.tooltips.appliedenergistics2.Singularity";
                    break;
                }
                default: {
                    return Collections.emptyList();
                }
            }
            return Splitter.on((String)"\\n").splitToList((CharSequence)I18n.func_135052_a((String)key, (Object[])new Object[]{this.condenserOutput.requiredPower}));
        }
        return Collections.emptyList();
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.buttonIcon.draw(minecraft);
    }
}

