/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.util.AEPartLocation;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.SlotOutput;
import appeng.container.slot.SlotRestrictedInput;
import appeng.tile.spatial.TileSpatialIOPort;
import appeng.util.Platform;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class ContainerSpatialIOPort
extends AEBaseContainer {
    @GuiSync(value=0)
    public long currentPower;
    @GuiSync(value=1)
    public long maxPower;
    @GuiSync(value=2)
    public long reqPower;
    @GuiSync(value=3)
    public long eff;
    private IGrid network;
    private int delay = 40;

    public ContainerSpatialIOPort(InventoryPlayer ip, TileSpatialIOPort spatialIOPort) {
        super(ip, spatialIOPort, null);
        if (Platform.isServer()) {
            this.network = spatialIOPort.getGridNode(AEPartLocation.INTERNAL).getGrid();
        }
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.SPATIAL_STORAGE_CELLS, (IInventory)spatialIOPort, 0, 52, 48, this.getInventoryPlayer()));
        this.func_75146_a(new SlotOutput((IInventory)spatialIOPort, 1, 113, 48, SlotRestrictedInput.PlacableItemType.SPATIAL_STORAGE_CELLS.IIcon));
        this.bindPlayerInventory(ip, 0, 115);
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            ++this.delay;
            if (this.delay > 15 && this.network != null) {
                this.delay = 0;
                IEnergyGrid eg = (IEnergyGrid)this.network.getCache(IEnergyGrid.class);
                ISpatialCache sc = (ISpatialCache)this.network.getCache(ISpatialCache.class);
                if (eg != null) {
                    this.setCurrentPower((long)(100.0 * eg.getStoredPower()));
                    this.setMaxPower((long)(100.0 * eg.getMaxStoredPower()));
                    this.setRequiredPower((long)(100.0 * (double)sc.requiredPower()));
                    this.setEfficency((long)(100.0f * sc.currentEfficiency()));
                }
            }
        }
        super.func_75142_b();
    }

    public long getCurrentPower() {
        return this.currentPower;
    }

    private void setCurrentPower(long currentPower) {
        this.currentPower = currentPower;
    }

    public long getMaxPower() {
        return this.maxPower;
    }

    private void setMaxPower(long maxPower) {
        this.maxPower = maxPower;
    }

    public long getRequiredPower() {
        return this.reqPower;
    }

    private void setRequiredPower(long reqPower) {
        this.reqPower = reqPower;
    }

    public long getEfficency() {
        return this.eff;
    }

    private void setEfficency(long eff) {
        this.eff = eff;
    }
}

