/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.block.AEBaseTileBlock;
import appeng.block.misc.BlockSkyCompass;
import appeng.client.render.model.SkyCompassBakedModel;
import appeng.tile.misc.TileSkyCompass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SkyCompassTESR
extends FastTESR<TileSkyCompass> {
    private static BlockRendererDispatcher blockRenderer;

    public void renderTileEntityFast(TileSkyCompass te, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer buffer) {
        if (!te.func_145830_o()) {
            return;
        }
        if (blockRenderer == null) {
            blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        }
        BlockPos pos = te.func_174877_v();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)te.func_145831_w(), (BlockPos)pos);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177227_a().contains(Properties.StaticProperty)) {
            state = state.func_177226_a((IProperty)Properties.StaticProperty, (Comparable)Boolean.valueOf(false));
        }
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState exState = (IExtendedBlockState)state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos);
            IBakedModel model = blockRenderer.func_175023_a().func_178125_b(exState.getClean());
            exState = exState.withProperty((IUnlistedProperty)BlockSkyCompass.ROTATION, (Object)Float.valueOf(SkyCompassTESR.getRotation(te)));
            EnumFacing forward = (EnumFacing)exState.getValue((IUnlistedProperty)AEBaseTileBlock.FORWARD);
            EnumFacing up = (EnumFacing)exState.getValue((IUnlistedProperty)AEBaseTileBlock.UP);
            if (forward == EnumFacing.UP || forward == EnumFacing.DOWN) {
                up = EnumFacing.NORTH;
            }
            exState = exState.withProperty((IUnlistedProperty)AEBaseTileBlock.FORWARD, (Object)up).withProperty((IUnlistedProperty)AEBaseTileBlock.UP, (Object)forward);
            buffer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
            blockRenderer.func_175019_b().func_178267_a((IBlockAccess)world, model, (IBlockState)exState, pos, buffer, false);
        }
    }

    private static float getRotation(TileSkyCompass skyCompass) {
        float rotation = skyCompass.getForward() == EnumFacing.UP || skyCompass.getForward() == EnumFacing.DOWN ? SkyCompassBakedModel.getAnimatedRotation(skyCompass.func_174877_v(), false) : SkyCompassBakedModel.getAnimatedRotation(null, false);
        if (skyCompass.getForward() == EnumFacing.DOWN) {
            rotation = SkyCompassTESR.flipidiy(rotation);
        }
        return rotation;
    }

    private static float flipidiy(float rad) {
        float x = (float)Math.cos(rad);
        float y = (float)Math.sin(rad);
        return (float)Math.atan2(-y, x);
    }
}

