/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.AEPartLocation;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseTileBlock;
import appeng.core.sync.GuiBridge;
import appeng.tile.misc.TileInterface;
import appeng.util.Platform;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInterface
extends AEBaseTileBlock {
    private static final PropertyBool OMNIDIRECTIONAL = PropertyBool.func_177716_a((String)"omnidirectional");

    public BlockInterface() {
        super(Material.field_151573_f);
        this.setTileEntity(TileInterface.class);
    }

    @Override
    protected IProperty[] getAEStates() {
        return new IProperty[]{OMNIDIRECTIONAL};
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileInterface te = (TileInterface)this.getTileEntity(world, pos);
        boolean omniDirectional = true;
        if (te != null) {
            omniDirectional = te.isOmniDirectional();
        }
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)OMNIDIRECTIONAL, (Comparable)Boolean.valueOf(omniDirectional));
    }

    @Override
    public boolean onActivated(World w, BlockPos pos, EntityPlayer p, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (p.func_70093_af()) {
            return false;
        }
        TileInterface tg = (TileInterface)this.getTileEntity((IBlockAccess)w, pos);
        if (tg != null) {
            if (Platform.isServer()) {
                Platform.openGUI(p, tg, AEPartLocation.fromFacing(side), GuiBridge.GUI_INTERFACE);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasCustomRotation() {
        return true;
    }

    @Override
    protected void customRotateBlock(IOrientable rotatable, EnumFacing axis) {
        if (rotatable instanceof TileInterface) {
            ((TileInterface)rotatable).setSide(axis);
        }
    }
}

