/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LanguageHelper {
    private static Map<String, String> preprocesssed = new HashMap<String, String>();
    public static Map<String, String> globals = new HashMap<String, String>();

    public static String getLocalization(String key) {
        String localization = LanguageHelper.getLocalization(key, true);
        if (preprocesssed.containsKey(key)) {
            return preprocesssed.get(key);
        }
        if (localization.contains("{{!")) {
            while (localization.contains("{{!")) {
                int startingIndex = localization.indexOf("{{!");
                int endingIndex = localization.substring(startingIndex).indexOf("}}") + startingIndex;
                String fragment = localization.substring(startingIndex + 3, endingIndex);
                try {
                    String replacement = globals.get(fragment.toLowerCase());
                    localization = localization.substring(0, startingIndex) + replacement + localization.substring(endingIndex + 2);
                }
                catch (Exception e) {
                    localization = localization.substring(0, startingIndex) + localization.substring(endingIndex + 2);
                }
            }
            preprocesssed.put(key, localization);
        }
        return localization;
    }

    private static String getLocalization(String key, boolean fallback) {
        String localization = I18n.func_74838_a((String)("xreliquary." + key));
        if (localization.equals(key) && fallback) {
            localization = I18n.func_150826_b((String)("xreliquary." + key));
        }
        return localization;
    }

    public static void formatTooltip(String langName, ImmutableMap<String, String> toFormat, List<String> list) {
        String langTooltip = LanguageHelper.getLocalization(langName);
        if (langTooltip == null || langTooltip.equals(langName)) {
            return;
        }
        if (toFormat != null) {
            for (Map.Entry toReplace : toFormat.entrySet()) {
                langTooltip = langTooltip.replace("{{" + (String)toReplace.getKey() + "}}", (CharSequence)toReplace.getValue());
            }
        }
        for (String descriptionLine : langTooltip.split(";")) {
            if (descriptionLine == null || descriptionLine.length() <= 0) continue;
            list.add(descriptionLine);
        }
    }
}

