/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.FakePlayer;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.reference.Settings;

public class PedestalShearsWrapper
implements IPedestalActionItemWrapper {
    private boolean isShearingBlock = false;
    private BlockPos blockPosBeingSheared;
    private Queue<BlockPos> blockQueue = new ArrayDeque<BlockPos>();

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        int shearsRange;
        World world = pedestal.getTheWorld();
        BlockPos pos = pedestal.getBlockPos();
        FakePlayer fakePlayer = pedestal.getFakePlayer();
        if (!this.shearAnimals(stack, world, fakePlayer, pos, shearsRange = Settings.Pedestal.shearsWrapperRange) && !this.shearBlocks(stack, world, pedestal, fakePlayer, pos, shearsRange)) {
            pedestal.setActionCoolDown(100);
            return;
        }
        if (!this.isShearingBlock) {
            pedestal.setActionCoolDown(Settings.Pedestal.shearsWrapperCooldown);
        }
        if (stack.field_77994_a == 0) {
            pedestal.destroyCurrentItem();
        }
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }

    private boolean shearBlocks(ItemStack stack, World world, IPedestal pedestal, FakePlayer fakePlayer, BlockPos pos, int shearsRange) {
        if (!this.isShearingBlock) {
            if (this.blockQueue.isEmpty()) {
                this.updateQueue(stack, world, pos, shearsRange);
                if (this.blockQueue.isEmpty()) {
                    return false;
                }
            }
            this.blockPosBeingSheared = this.blockQueue.remove();
            IBlockState blockState = world.func_180495_p(this.blockPosBeingSheared);
            if (blockState.func_177230_c() instanceof IShearable && ((IShearable)blockState.func_177230_c()).isShearable(stack, (IBlockAccess)world, this.blockPosBeingSheared)) {
                float hardness = blockState.func_177230_c().func_176195_g(blockState, world, this.blockPosBeingSheared);
                float digSpeed = stack.func_77973_b().func_150893_a(stack, blockState);
                pedestal.setActionCoolDown((int)(hardness * 1.5f * 20.0f / digSpeed));
                this.isShearingBlock = true;
            }
        } else {
            stack.func_77973_b().onBlockStartBreak(stack, this.blockPosBeingSheared, (EntityPlayer)fakePlayer);
            IBlockState blockState = world.func_180495_p(this.blockPosBeingSheared);
            world.func_175698_g(this.blockPosBeingSheared);
            world.func_175718_b(2001, this.blockPosBeingSheared, Block.func_176210_f((IBlockState)blockState));
            this.isShearingBlock = false;
        }
        return true;
    }

    private void updateQueue(ItemStack stack, World world, BlockPos pos, int shearsRange) {
        for (int y = pos.func_177956_o() - shearsRange; y <= pos.func_177956_o() + shearsRange; ++y) {
            for (int x = pos.func_177958_n() - shearsRange; x <= pos.func_177958_n() + shearsRange; ++x) {
                for (int z = pos.func_177952_p() - shearsRange; z <= pos.func_177952_p() + shearsRange; ++z) {
                    BlockPos currentBlockPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(currentBlockPos);
                    if (!(blockState.func_177230_c() instanceof IShearable) || !((IShearable)blockState.func_177230_c()).isShearable(stack, (IBlockAccess)world, currentBlockPos)) continue;
                    this.blockQueue.add(currentBlockPos);
                }
            }
        }
    }

    private boolean shearAnimals(ItemStack stack, World world, FakePlayer fakePlayer, BlockPos pos, int shearsRange) {
        List entities = world.func_72872_a(EntityAnimal.class, new AxisAlignedBB((double)(pos.func_177958_n() - shearsRange), (double)(pos.func_177956_o() - shearsRange), (double)(pos.func_177952_p() - shearsRange), (double)(pos.func_177958_n() + shearsRange), (double)(pos.func_177956_o() + shearsRange), (double)(pos.func_177952_p() + shearsRange)));
        for (EntityAnimal animal : entities) {
            if (!(animal instanceof IShearable) || !((IShearable)animal).isShearable(stack, (IBlockAccess)world, animal.func_180425_c())) continue;
            fakePlayer.func_184611_a(EnumHand.MAIN_HAND, stack);
            fakePlayer.func_184822_a((Entity)animal, stack, EnumHand.MAIN_HAND);
            return true;
        }
        return false;
    }
}

