/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import xreliquary.Reliquary;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.reference.Settings;

public class ItemMobCharm
extends ItemBase {
    private static final String TYPE_TAG = "type";

    public ItemMobCharm() {
        super("mob_charm");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(Settings.MobCharm.durability);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.canRepair = false;
    }

    public String func_77667_c(ItemStack ist) {
        return "item.mob_charm_" + this.getType(ist);
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List<ItemStack> subItems) {
        for (byte i = 0; i < 14; i = (byte)(i + 1)) {
            ItemStack subItem = new ItemStack(item);
            this.setType(subItem, i);
            subItems.add(subItem);
        }
    }

    public byte getType(ItemStack stack) {
        if (stack.func_77973_b() != ModItems.mobCharm || stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b(TYPE_TAG)) {
            return -1;
        }
        return stack.func_77978_p().func_74771_c(TYPE_TAG);
    }

    public void setType(ItemStack stack, byte type) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        compound.func_74774_a(TYPE_TAG, type);
        stack.func_77982_d(compound);
    }

    public byte getMobCharmTypeForEntity(Entity entity) {
        if (entity instanceof EntityGhast) {
            return 9;
        }
        if (entity instanceof EntityMagmaCube) {
            return 11;
        }
        if (entity instanceof EntitySlime) {
            return 10;
        }
        if (entity instanceof EntityPigZombie) {
            return 5;
        }
        if (entity instanceof EntityZombie) {
            return 0;
        }
        if (entity instanceof EntitySkeleton) {
            if (((EntitySkeleton)entity).func_189771_df() == SkeletonType.WITHER) {
                return 2;
            }
            return 1;
        }
        if (entity instanceof EntityCreeper) {
            return 3;
        }
        if (entity instanceof EntityWitch) {
            return 4;
        }
        if (entity instanceof EntityCaveSpider) {
            return 6;
        }
        if (entity instanceof EntitySpider) {
            return 7;
        }
        if (entity instanceof EntityEnderman) {
            return 8;
        }
        if (entity instanceof EntityBlaze) {
            return 12;
        }
        if (entity instanceof EntityGuardian && !((EntityGuardian)entity).func_175461_cl()) {
            return 13;
        }
        return -1;
    }
}

