/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItem;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.fluid.FluidHandlerHeroMedallion;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.XpHelper;

public class ItemHeroMedallion
extends ItemToggleable
implements IPedestalActionItem {
    public ItemHeroMedallion() {
        super("hero_medallion");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return NBTHelper.getBoolean("enabled", stack);
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"experience", (Object)String.valueOf(NBTHelper.getInteger("experience", ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.GREEN + "XP")), list);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, list);
    }

    private int getExperienceMinimum() {
        return Settings.HeroMedallion.experienceLevelMinimum;
    }

    private int getExperienceMaximum() {
        return Settings.HeroMedallion.experienceLevelMaximum;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean f) {
        if (!this.isEnabled(ist)) {
            return;
        }
        if (e instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e;
            int levelLoop = 0;
            while (true) {
                double d = levelLoop;
                double d2 = !player.field_71075_bZ.field_75098_d ? (double)player.field_71068_ca : 30.0;
                if (!(d <= Math.sqrt(d2))) break;
                if ((player.field_71068_ca > this.getExperienceMinimum() || player.field_71106_cc >= 1.0f / (float)player.func_71050_bK() || player.field_71075_bZ.field_75098_d) && this.getExperience(ist) < Settings.HeroMedallion.experienceLimit) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        this.decreasePlayerExperience(player);
                    }
                    this.increaseMedallionExperience(ist);
                }
                ++levelLoop;
            }
        }
    }

    private void decreasePlayerExperience(EntityPlayer player) {
        player.field_71106_cc -= 1.0f / (float)player.func_71050_bK();
        player.field_71067_cb -= Math.min(1, player.field_71067_cb);
        if (player.field_71106_cc < 0.0f) {
            this.decreasePlayerLevel(player);
        }
    }

    private void decreaseMedallionExperience(ItemStack ist) {
        this.decreaseMedallionExperience(ist, 1);
    }

    private void decreaseMedallionExperience(ItemStack ist, int experience) {
        this.setExperience(ist, this.getExperience(ist) - experience);
    }

    private void decreasePlayerLevel(EntityPlayer player) {
        float experienceToRemove = -player.field_71106_cc * (float)player.func_71050_bK();
        --player.field_71068_ca;
        player.field_71106_cc = 1.0f - experienceToRemove / (float)player.func_71050_bK();
    }

    private void increasePlayerExperience(EntityPlayer player) {
        player.func_71023_q(1);
    }

    private void increaseMedallionExperience(ItemStack ist) {
        this.setExperience(ist, this.getExperience(ist) + 1);
    }

    public int getExperience(ItemStack stack) {
        return NBTHelper.getInteger("experience", stack);
    }

    public void setExperience(ItemStack stack, int i) {
        NBTHelper.setInteger("experience", stack, i);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack ist, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
        }
        if (player.func_70093_af()) {
            return super.func_77659_a(ist, world, player, hand);
        }
        RayTraceResult rayTraceResult = this.func_77621_a(world, player, true);
        if (rayTraceResult == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            int playerLevel = player.field_71068_ca;
            while (player.field_71068_ca < this.getExperienceMaximum() && playerLevel == player.field_71068_ca && (this.getExperience(ist) > 0 || player.field_71075_bZ.field_75098_d)) {
                this.increasePlayerExperience(player);
                if (player.field_71075_bZ.field_75098_d) continue;
                this.decreaseMedallionExperience(ist);
            }
        } else {
            BlockPos hitPos = rayTraceResult.func_178782_a().func_177971_a(rayTraceResult.field_178784_b.func_176730_m());
            this.spawnXpOnGround(ist, world, hitPos);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
    }

    private void spawnXpOnGround(ItemStack ist, World world, BlockPos hitPos) {
        int xp;
        if (this.getExperience(ist) >= xp) {
            int j;
            this.decreaseMedallionExperience(ist, xp);
            for (xp = Math.min(Settings.HeroMedallion.experienceDrop, this.getExperience(ist)); xp > 0; xp -= j) {
                j = EntityXPOrb.func_70527_a((int)xp);
                world.func_72838_d((Entity)new EntityXPOrb(world, (double)hitPos.func_177958_n(), (double)hitPos.func_177956_o(), (double)hitPos.func_177952_p(), j));
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerHeroMedallion(stack);
    }

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        List<BlockPos> posInRange = pedestal.getPedestalsInRange(Settings.HeroMedallion.pedestalRange);
        World world = pedestal.getTheWorld();
        for (BlockPos pedestalPos : posInRange) {
            IInventory pedestalInventory = (IInventory)world.func_175625_s(pedestalPos);
            if (pedestalInventory == null) continue;
            List<ItemStack> toRepair = this.getMendingItemsForRepair(pedestalInventory);
            for (ItemStack itemToRepair : toRepair) {
                int xpToRepair = Math.min(Settings.HeroMedallion.pedestalRepairStepXP, this.getExperience(stack));
                int durabilityToRepair = Math.min(XpHelper.xpToDurability(xpToRepair), itemToRepair.func_77952_i());
                this.setExperience(stack, this.getExperience(stack) - XpHelper.durabilityToXp(durabilityToRepair));
                itemToRepair.func_77964_b(itemToRepair.func_77952_i() - durabilityToRepair);
            }
        }
        pedestal.setActionCoolDown(Settings.HeroMedallion.pedestalCoolDown);
    }

    private List<ItemStack> getMendingItemsForRepair(IInventory inventory) {
        ArrayList<ItemStack> stacksToReturn = new ArrayList<ItemStack>();
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack == null || !stack.func_77951_h() || stack.func_77952_i() <= 1 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) <= 0) continue;
            stacksToReturn.add(stack);
        }
        return stacksToReturn;
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }
}

