/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import xreliquary.items.ItemIceMagusRod;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class ItemGlacialStaff
extends ItemIceMagusRod {
    public ItemGlacialStaff() {
        super("glacial_staff");
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack ist, World world, EntityPlayer player, EnumHand hand) {
        return super.func_77659_a(ist, world, player, hand);
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List<String> list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(NBTHelper.getInteger("snowballs", ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.BLUE + Items.field_151126_ay.func_77653_i(new ItemStack(Items.field_151126_ay)))), list);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, list);
    }

    public boolean onLeftClickEntity(ItemStack ist, EntityPlayer player, Entity e) {
        if (e instanceof EntityLivingBase && NBTHelper.getInteger("snowballs", ist) >= this.getSnowballCost()) {
            EntityLivingBase livingBase = (EntityLivingBase)e;
            PotionEffect slow = new PotionEffect(MobEffects.field_76421_d, 30, 0);
            if (livingBase.func_70660_b(MobEffects.field_76421_d) != null) {
                slow = new PotionEffect(MobEffects.field_76421_d, Math.min(livingBase.func_70660_b(MobEffects.field_76421_d).func_76459_b() + 30, 300), Math.min(livingBase.func_70660_b(MobEffects.field_76421_d).func_76458_c() + 1, 4));
            }
            ((EntityLivingBase)e).func_70690_d(slow);
            e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)slow.func_76458_c());
            NBTHelper.setInteger("snowballs", ist, NBTHelper.getInteger("snowballs", ist) - this.getSnowballCost());
        }
        return super.onLeftClickEntity(ist, player, e);
    }

    @Override
    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        super.func_77663_a(ist, world, e, i, b);
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b) - 1;
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        if (this.isEnabled(ist)) {
            for (int xOff = -2; xOff <= 2; ++xOff) {
                for (int zOff = -2; zOff <= 2; ++zOff) {
                    if (Math.abs(xOff) == 2 && Math.abs(zOff) == 2) continue;
                    this.doFreezeCheck(ist, x, y, z, world, xOff, zOff);
                }
            }
        }
        if (!world.field_72995_K) {
            for (BlockPos pos : this.getBlockLocations(ist)) {
                int xOff = Math.abs(MathHelper.func_76128_c((double)player.field_70165_t) - pos.func_177958_n());
                int yOff = Math.abs(MathHelper.func_76128_c((double)player.field_70163_u) - pos.func_177956_o());
                int zOff = Math.abs(MathHelper.func_76128_c((double)player.field_70161_v) - pos.func_177952_p());
                if (xOff < 3 && yOff < 3 && zOff < 3 && (xOff != 2 || zOff != 2)) continue;
                this.doThawCheck(ist, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world);
            }
        }
    }

    private BlockPos[] getBlockLocations(ItemStack ist) {
        NBTTagCompound tagCompound = ist.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (tagCompound.func_74781_a("BlockLocations") == null) {
            tagCompound.func_74782_a("BlockLocations", (NBTBase)new NBTTagList());
        }
        NBTTagList tagList = tagCompound.func_150295_c("BlockLocations", 10);
        BlockPos[] locations = new BlockPos[tagList.func_74745_c()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbtLocation = (NBTTagCompound)tagList.func_179238_g(i);
            locations[i] = new BlockPos(nbtLocation.func_74762_e("x"), nbtLocation.func_74762_e("y"), nbtLocation.func_74762_e("z"));
        }
        return locations;
    }

    public void doFreezeCheck(ItemStack ist, int x, int y, int z, World world, int xOff, int zOff) {
        block3: {
            IBlockState blockState;
            block2: {
                blockState = world.func_180495_p(new BlockPos(x += xOff, y, z += zOff));
                if (blockState.func_177230_c().func_149688_o(blockState) != Material.field_151586_h || (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0 || !world.func_175623_d(new BlockPos(x, y + 1, z))) break block2;
                this.addFrozenBlockToList(ist, x, y, z);
                world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150403_cj.func_176223_P());
                for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = world.field_73012_v.nextFloat();
                    float yVel = world.field_73012_v.nextFloat() + 0.5f;
                    float zVel = world.field_73012_v.nextFloat();
                    world.func_175688_a(EnumParticleTypes.REDSTONE, (double)((float)x + xVel), (double)((float)y + yVel), (double)((float)z + zVel), 0.75, 0.75, 1.0, new int[0]);
                }
                break block3;
            }
            if (blockState.func_177230_c().func_149688_o(blockState) != Material.field_151587_i || (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) break block3;
            this.addFrozenBlockToList(ist, x, y, z);
            world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150343_Z.func_176223_P());
            for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                float xVel = world.field_73012_v.nextFloat();
                float yVel = world.field_73012_v.nextFloat() + 0.5f;
                float zVel = world.field_73012_v.nextFloat();
                world.func_175688_a(world.field_73012_v.nextInt(3) == 0 ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL, (double)((float)x + xVel), (double)((float)y + yVel), (double)((float)z + zVel), 0.0, 0.2, 0.0, new int[0]);
            }
        }
    }

    public void doThawCheck(ItemStack ist, int x, int y, int z, World world) {
        block4: {
            IBlockState blockState;
            block3: {
                blockState = world.func_180495_p(new BlockPos(x, y, z));
                if (blockState != Blocks.field_150403_cj.func_176223_P()) break block3;
                if (!this.removeFrozenBlockFromList(ist, x, y, z)) break block4;
                world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150355_j.func_176223_P());
                for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = world.field_73012_v.nextFloat();
                    float yVel = world.field_73012_v.nextFloat() + 0.5f;
                    float zVel = world.field_73012_v.nextFloat();
                    world.func_175688_a(world.field_73012_v.nextInt(3) == 0 ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL, (double)((float)x + xVel), (double)((float)y + yVel), (double)((float)z + zVel), 0.0, 0.2, 0.0, new int[0]);
                }
                break block4;
            }
            if (blockState == Blocks.field_150343_Z.func_176223_P() && this.removeFrozenBlockFromList(ist, x, y, z)) {
                world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150353_l.func_176223_P());
                float red = 1.0f;
                float green = 0.0f;
                float blue = 0.0f;
                for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = world.field_73012_v.nextFloat();
                    float yVel = world.field_73012_v.nextFloat() + 0.5f;
                    float zVel = world.field_73012_v.nextFloat();
                    world.func_175688_a(EnumParticleTypes.REDSTONE, (double)((float)x + xVel), (double)((float)y + yVel), (double)((float)z + zVel), (double)red, (double)green, (double)blue, new int[0]);
                }
            }
        }
    }

    private void addFrozenBlockToList(ItemStack ist, int x, int y, int z) {
        NBTTagCompound tagCompound = ist.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (tagCompound.func_74781_a("BlockLocations") == null) {
            tagCompound.func_74782_a("BlockLocations", (NBTBase)new NBTTagList());
        }
        NBTTagList tagList = tagCompound.func_150295_c("BlockLocations", 10);
        NBTTagCompound newTagData = new NBTTagCompound();
        newTagData.func_74768_a("x", x);
        newTagData.func_74768_a("y", y);
        newTagData.func_74768_a("z", z);
        tagList.func_74742_a((NBTBase)newTagData);
        tagCompound.func_74782_a("BlockLocations", (NBTBase)tagList);
        ist.func_77982_d(tagCompound);
    }

    private boolean removeFrozenBlockFromList(ItemStack ist, int x, int y, int z) {
        NBTTagCompound tagCompound = ist.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (tagCompound.func_74781_a("BlockLocations") == null) {
            tagCompound.func_74782_a("BlockLocations", (NBTBase)new NBTTagList());
        }
        NBTTagList tagList = tagCompound.func_150295_c("BlockLocations", 10);
        boolean removedBlock = false;
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagItemData = tagList.func_150305_b(i);
            if (tagItemData.func_74762_e("x") != x || tagItemData.func_74762_e("y") != y || tagItemData.func_74762_e("z") != z) continue;
            tagItemData.func_74757_a("remove", true);
            removedBlock = true;
        }
        NBTTagList newTagList = new NBTTagList();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagItemData = tagList.func_150305_b(i);
            if (tagItemData.func_74767_n("remove")) continue;
            NBTTagCompound newTagData = new NBTTagCompound();
            newTagData.func_74768_a("x", tagItemData.func_74762_e("x"));
            newTagData.func_74768_a("y", tagItemData.func_74762_e("y"));
            newTagData.func_74768_a("z", tagItemData.func_74762_e("z"));
            newTagList.func_74742_a((NBTBase)newTagData);
        }
        tagCompound.func_74782_a("BlockLocations", (NBTBase)newTagList);
        ist.func_77982_d(tagCompound);
        return removedBlock;
    }
}

