/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler.config;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import xreliquary.handler.ConfigurationHandler;
import xreliquary.reference.Settings;
import xreliquary.util.StackHelper;
import xreliquary.util.alkahestry.AlkahestChargeRecipe;
import xreliquary.util.alkahestry.AlkahestCraftRecipe;

public class AlkahestConfiguration {
    private static final int TOME_COST_LOW_TIER = 4;
    private static final int TOME_COST_MIDDLE_TIER = 8;
    private static final int TOME_COST_HIGH_TIER = 32;
    private static final int TOME_COST_UBER_TIER = 64;

    public static void loadAlkahestBaseItem() {
        String registryName = ConfigurationHandler.getString("base_item", "item_and_block_settings.alkahestry_tome", Items.field_151137_ax.getRegistryName().toString(), "Base Item name in format \"ModId:item\"");
        int meta = ConfigurationHandler.getInt("base_item_meta", "item_and_block_settings.alkahestry_tome", 0, 0, 16, "meta of the Base Item");
        String[] splitName = registryName.split(":");
        Settings.AlkahestryTome.baseItem = StackHelper.getItemStackFromNameMeta(splitName[0], splitName[1], meta);
        Settings.AlkahestryTome.baseItemWorth = ConfigurationHandler.getInt("base_item_worth", "item_and_block_settings.alkahestry_tome", 1, 1, 1000, "How much charge the Base Item is worth");
    }

    public static void loadAlkahestChargingRecipes() {
        String categoryKey = "item_and_block_settings.alkahestry_tome.charging_recipes";
        ConfigCategory category = ConfigurationHandler.configuration.getCategory(categoryKey);
        category.setLanguageKey(ConfigurationHandler.getCategoryLangRef(categoryKey));
        category.setComment("List of recipes that can be used with Alkahestry Tome to charge it. The values are item name \"modID:name\", meta, charge points.\n");
        if (category.isEmpty()) {
            AlkahestConfiguration.addDefaultAlkahestChargingRecipes(category);
        }
        AlkahestConfiguration.loadAlkahestChargingRecipesIntoSettings(category);
    }

    private static void loadAlkahestChargingRecipesIntoSettings(ConfigCategory category) {
        Settings.AlkahestryTome.chargingRecipes.clear();
        for (Map.Entry entry : category.getValues().entrySet()) {
            String[] nameParts = ((String)entry.getKey()).split(":");
            int[] values = ((Property)entry.getValue()).getIntList();
            String modId = nameParts[0];
            String name = nameParts[1];
            int meta = 0;
            boolean allSubitems = false;
            if (name.contains("|")) {
                nameParts = name.split("\\|");
                name = nameParts[0];
                if ("*".equals(nameParts[1])) {
                    allSubitems = true;
                } else {
                    meta = Integer.parseInt(nameParts[1]);
                }
            } else if (values.length > 1) {
                meta = values[0];
            }
            int charge = values[values.length - 1];
            if (allSubitems) {
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modId, name));
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(modId, name));
                ArrayList subItems = new ArrayList();
                if (item != null) {
                    item.func_150895_a(item, null, subItems);
                } else {
                    block.func_149666_a(Item.func_150898_a((Block)block), null, subItems);
                }
                for (ItemStack stack : subItems) {
                    Settings.AlkahestryTome.chargingRecipes.put(((String)entry.getKey()).replace("*", String.valueOf(stack.func_77960_j())), new AlkahestChargeRecipe(stack, charge));
                }
                continue;
            }
            ItemStack stack = StackHelper.getItemStackFromNameMeta(modId, name, meta);
            if (stack == null) continue;
            Settings.AlkahestryTome.chargingRecipes.put((String)entry.getKey(), new AlkahestChargeRecipe(stack, charge));
        }
    }

    private static void addDefaultAlkahestChargingRecipes(ConfigCategory category) {
        AlkahestConfiguration.addConfigAlkahestChargingRecipe(category, Blocks.field_150451_bX.getRegistryName().toString(), 9);
        AlkahestConfiguration.addConfigAlkahestChargingRecipe(category, Items.field_151137_ax.getRegistryName().toString(), 1);
        AlkahestConfiguration.addConfigAlkahestChargingRecipe(category, Blocks.field_150426_aN.getRegistryName().toString(), 4);
        AlkahestConfiguration.addConfigAlkahestChargingRecipe(category, Items.field_151114_aO.getRegistryName().toString(), 1);
    }

    private static void addConfigAlkahestChargingRecipe(ConfigCategory category, String item, Integer charge) {
        AlkahestConfiguration.addConfigAlkahestChargingRecipe(category, item, 0, charge);
    }

    private static void addConfigAlkahestChargingRecipe(ConfigCategory category, String item, Integer meta, Integer charge) {
        Property prop = new Property(item, new String[]{charge.toString()}, Property.Type.INTEGER);
        category.put(item, prop);
    }

    public static void loadAlkahestCraftingRecipes() {
        String categoryKey = "item_and_block_settings.alkahestry_tome.crafting_recipes";
        ConfigCategory category = ConfigurationHandler.configuration.getCategory(categoryKey);
        category.setLanguageKey(ConfigurationHandler.getCategoryLangRef(categoryKey));
        category.setComment("List of recipes that can be used with Alkahestry Tome to craft items. The values are item name \"modID:name\", meta, yield, cost.");
        if (category.isEmpty()) {
            AlkahestConfiguration.addDefaultAlkahestCraftingRecipes(category);
        }
        AlkahestConfiguration.loadAlkahestCraftingRecipesIntoSettings(category);
    }

    private static void loadAlkahestCraftingRecipesIntoSettings(ConfigCategory category) {
        Settings.AlkahestryTome.craftingRecipes.clear();
        for (Map.Entry entry : category.getValues().entrySet()) {
            String[] nameParts = ((String)entry.getKey()).split(":");
            int[] values = ((Property)entry.getValue()).getIntList();
            String modId = nameParts[0];
            String name = nameParts[1];
            int meta = 0;
            boolean allSubitems = false;
            if (name.contains("|")) {
                nameParts = name.split("\\|");
                name = nameParts[0];
                if ("*".equals(nameParts[1])) {
                    allSubitems = true;
                } else {
                    meta = Integer.parseInt(nameParts[1]);
                }
            } else if (values.length > 2) {
                meta = values[0];
            }
            int yield = values[values.length - 2];
            int cost = values[values.length - 1];
            if (modId.toLowerCase().equals("oredictionary")) {
                Settings.AlkahestryTome.craftingRecipes.put((String)entry.getKey(), new AlkahestCraftRecipe(name, yield, cost));
                continue;
            }
            if (allSubitems) {
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modId, name));
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(modId, name));
                ArrayList subItems = new ArrayList();
                if (item != null) {
                    item.func_150895_a(item, null, subItems);
                } else {
                    block.func_149666_a(Item.func_150898_a((Block)block), null, subItems);
                }
                for (ItemStack stack : subItems) {
                    Settings.AlkahestryTome.craftingRecipes.put(((String)entry.getKey()).replace("*", String.valueOf(stack.func_77960_j())), new AlkahestCraftRecipe(stack, yield, cost));
                }
                continue;
            }
            ItemStack stack = StackHelper.getItemStackFromNameMeta(modId, name, meta);
            String key = modId + ":" + name + "|" + meta;
            if (stack == null) continue;
            Settings.AlkahestryTome.craftingRecipes.put(key, new AlkahestCraftRecipe(stack, yield, cost));
        }
    }

    private static void addDefaultAlkahestCraftingRecipes(ConfigCategory category) {
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150346_d.getRegistryName().toString(), 32, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150347_e.getRegistryName().toString(), 32, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150354_m.getRegistryName().toString(), 32, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150351_n.getRegistryName().toString(), 16, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150322_A.getRegistryName().toString(), 8, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150435_aG.getRegistryName().toString(), 2, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150424_aL.getRegistryName().toString(), 8, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151044_h.getRegistryName().toString(), 1, 4, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151100_aR.getRegistryName().toString(), 4, 1, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150343_Z.getRegistryName().toString(), 4, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150425_aM.getRegistryName().toString(), 8, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150385_bj.getRegistryName().toString(), 4, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150377_bs.getRegistryName().toString(), 16, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151044_h.getRegistryName().toString(), 4, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151016_H.getRegistryName().toString(), 2, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151145_ak.getRegistryName().toString(), 8, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151043_k.getRegistryName().toString(), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151042_j.getRegistryName().toString(), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151166_bC.getRegistryName().toString(), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("tin_ingot"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("silver_ingot"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("copper_ingot"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("steel_ingot"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("ingotTin"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("ingotSilver"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("ingotCopper"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("ingotSteel"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151045_i.getRegistryName().toString(), 1, 64);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151156_bN.getRegistryName().toString(), 1, 256);
    }

    private static String oreDictionary(String name) {
        return "OreDictionary:" + name;
    }

    private static void addConfigAlkahestCraftingRecipe(ConfigCategory category, String item, Integer yield, Integer cost) {
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, item, 0, yield, cost);
    }

    private static void addConfigAlkahestCraftingRecipe(ConfigCategory category, String item, Integer meta, Integer yield, Integer cost) {
        Property prop = new Property(item + "|" + meta, new String[]{yield.toString(), cost.toString()}, Property.Type.INTEGER);
        category.put(item + "|" + meta, prop);
    }
}

