/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xreliquary.handler.config.AlkahestConfiguration;
import xreliquary.handler.config.BlockItemConfiguration;
import xreliquary.handler.config.EasyModeConfiguration;
import xreliquary.handler.config.HudConfiguration;
import xreliquary.reference.Settings;

public class ConfigurationHandler {
    public static Configuration configuration;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile, true);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        HudConfiguration.loadHudPositions();
        EasyModeConfiguration.loadEasyModeSettings();
        BlockItemConfiguration.loadBlockAndItemSettings();
        Settings.chestLootEnabled = ConfigurationHandler.getBoolean("chest_loot_enabled", "general", true, "Determines whether Reliquary items will be generated in chest loot (mostly mob drops, very rarely some lower level items)");
        configuration.getCategory("general").get("chest_loot_enabled").setRequiresMcRestart(true);
        Settings.wailaShiftForInfo = ConfigurationHandler.getBoolean("waila_shift_for_info", "general", false, "Whether player has to sneak to see additional info in waila");
        Settings.dropCraftingRecipesEnabled = ConfigurationHandler.getBoolean("mob_drop_crafting_recipes_enabled", "general", false, "Determines wheter Reliquary mob drops have crafting recipes");
        configuration.getCategory("general").get("mob_drop_crafting_recipes_enabled").setRequiresMcRestart(true);
        Settings.mobDropsEnabled = ConfigurationHandler.getBoolean("mob_drops_enabled", "general", true, "Whether mobs drop the Reliquary mob drops. This won't remove mob drop items from registry and replace them with something else, but allows to turn off the additional drops when mobs are killed by player. If this is turned off the mob drop crafting recipes turned on by the other setting can be used.");
        configuration.getCategory("general").get("mob_drops_enabled").setRequiresMcRestart(true);
        Settings.disabledItemsBlocks = ConfigurationHandler.getStringList("disabled_items_blocks", "general", Collections.emptyList(), "List of items and blocks that are supposed to be disabled. By default this is empty, but you can use the names of the blocks and items (e.g. \"fertile_lilypad\", \"wraith_node\", \"glacial_staff\") in this list and mod will not register those. It will also not register any recipes that include whatever is disabled.");
        configuration.getCategory("general").get("disabled_items_blocks").setRequiresMcRestart(true);
    }

    public static void postInit() {
        BlockItemConfiguration.loadEntitiesSettings();
        AlkahestConfiguration.loadAlkahestCraftingRecipes();
        AlkahestConfiguration.loadAlkahestChargingRecipes();
        AlkahestConfiguration.loadAlkahestBaseItem();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static List<String> getStringList(String name, String category, List<String> defaultValue, String comment) {
        return Arrays.asList(configuration.getStringList(name, category, defaultValue.toArray(new String[defaultValue.size()]), comment, new String[0], ConfigurationHandler.getConfigLangRef(category, name)));
    }

    public static boolean getBoolean(String name, String category, boolean defaultValue, String comment) {
        return configuration.getBoolean(name, category, defaultValue, comment, ConfigurationHandler.getConfigLangRef(category, name));
    }

    public static int getInt(String name, String category, int defaultValue, int minValue, int maxValue, String comment) {
        return configuration.getInt(name, category, defaultValue, minValue, maxValue, comment, ConfigurationHandler.getConfigLangRef(category, name));
    }

    public static String getString(String name, String category, String defaultValue, String comment) {
        return configuration.getString(name, category, defaultValue, comment, ConfigurationHandler.getConfigLangRef(category, name));
    }

    private static String getConfigLangRef(String category, String config) {
        return "xreliquary.config." + category + "." + config + ".label";
    }

    public static String getCategoryLangRef(String category) {
        return "xreliquary.config." + category + ".label";
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("xreliquary")) {
            ConfigurationHandler.loadConfiguration();
            ConfigurationHandler.postInit();
        }
    }
}

