/*
 * Decompiled with CFR 0.152.
 */
package elucent.roots.tileentity;

import elucent.roots.Roots;
import elucent.roots.ritual.RitualBase;
import elucent.roots.ritual.RitualManager;
import elucent.roots.tileentity.TEBase;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class TileEntityAltar
extends TEBase
implements ITickable {
    public ArrayList<ItemStack> inventory = new ArrayList();
    public ArrayList<ItemStack> incenses = new ArrayList();
    Random random = new Random();
    int ticker = 0;
    int progress = 0;
    String ritualName = null;
    RitualBase ritual = null;
    ItemStack resultItem = null;

    public void func_145839_a(NBTTagCompound tag) {
        int i;
        NBTTagList list;
        super.func_145839_a(tag);
        this.inventory = new ArrayList();
        if (tag.func_74764_b("inventory")) {
            list = tag.func_150295_c("inventory", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.inventory.add(ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i)));
            }
        }
        this.incenses = new ArrayList();
        if (tag.func_74764_b("incenses")) {
            list = tag.func_150295_c("incenses", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.incenses.add(ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i)));
            }
        }
        if (tag.func_74764_b("ritualName")) {
            this.ritualName = tag.func_74779_i("ritualName");
            this.ritual = RitualManager.getRitualFromName(this.ritualName);
        }
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        int i;
        NBTTagList list;
        super.func_189515_b(tag);
        if (this.inventory.size() > 0) {
            list = new NBTTagList();
            for (i = 0; i < this.inventory.size(); ++i) {
                if (this.inventory.get(i) == null) continue;
                list.func_74742_a((NBTBase)this.inventory.get(i).func_77955_b(new NBTTagCompound()));
            }
            tag.func_74782_a("inventory", (NBTBase)list);
        }
        if (this.incenses.size() > 0) {
            list = new NBTTagList();
            for (i = 0; i < this.incenses.size(); ++i) {
                if (this.incenses.get(i) == null) continue;
                list.func_74742_a((NBTBase)this.incenses.get(i).func_77955_b(new NBTTagCompound()));
            }
            tag.func_74782_a("incenses", (NBTBase)list);
        }
        if (this.ritualName != null) {
            tag.func_74778_a("ritualName", this.ritualName);
        }
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (world.field_72995_K) continue;
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.inventory.get(i));
            item.field_98038_p = true;
            world.func_72838_d((Entity)item);
        }
        this.func_145843_s();
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem == null && !player.func_70093_af() && this.progress == 0) {
            if (this.inventory.size() > 0) {
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, this.inventory.remove(this.inventory.size() - 1)));
                } else {
                    this.inventory.remove(this.inventory.size() - 1);
                }
                this.func_70296_d();
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                return true;
            }
        } else if (player.func_70093_af() && heldItem == null && this.progress == 0) {
            this.ritualName = null;
            this.ritual = null;
            for (int i = 0; i < RitualManager.rituals.size(); ++i) {
                if (!RitualManager.rituals.get(i).matches(this.func_145831_w(), this.func_174877_v())) continue;
                this.ritualName = RitualManager.rituals.get((int)i).name;
                this.ritual = RitualManager.rituals.get(i);
                this.incenses = RitualManager.getIncenses(world, this.func_174877_v());
                this.progress = 200;
                this.func_145831_w().func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, new SoundEvent(new ResourceLocation("roots:ritualCast")), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                this.func_70296_d();
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                return true;
            }
            if (this.ritualName == null) {
                if (world.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)"roots.error.noritual.name", (Object[])new Object[0])));
                }
                this.func_70296_d();
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                return true;
            }
        } else if (this.inventory.size() < 3 && this.progress == 0) {
            ItemStack toAdd = new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77952_i());
            if (heldItem.func_77942_o()) {
                toAdd.func_77982_d(heldItem.func_77978_p());
            }
            this.inventory.add(toAdd);
            --heldItem.field_77994_a;
            this.func_70296_d();
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        this.ticker = (int)((double)this.ticker + 3.0);
        if (this.ticker > 360) {
            this.ticker = 0;
        }
        if (this.progress > 0 && this.ritual != null) {
            --this.progress;
            if (this.func_145831_w().field_72995_K) {
                if (this.ritual.positions.size() > 0) {
                    BlockPos pos = this.ritual.positions.get(this.random.nextInt(this.ritual.positions.size())).func_177984_a().func_177982_a(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
                    if (this.random.nextInt(6) == 0) {
                        Roots.proxy.spawnParticleMagicAltarLineFX(this.func_145831_w(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.125, (double)pos.func_177952_p() + 0.5, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, this.ritual.color.field_72450_a, this.ritual.color.field_72448_b, this.ritual.color.field_72449_c);
                    } else {
                        Roots.proxy.spawnParticleMagicAltarLineFX(this.func_145831_w(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.125, (double)pos.func_177952_p() + 0.5, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, this.ritual.secondaryColor.field_72450_a, this.ritual.secondaryColor.field_72448_b, this.ritual.secondaryColor.field_72449_c);
                    }
                }
                if (this.random.nextInt(2) == 0) {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(360.0 * (double)(this.progress % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(360.0 * (double)(this.progress % 100) / 100.0)), this.ritual.color.field_72450_a, this.ritual.color.field_72448_b, this.ritual.color.field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(360.0 * (double)(this.progress % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(360.0 * (double)(this.progress % 100) / 100.0)), this.ritual.secondaryColor.field_72450_a, this.ritual.secondaryColor.field_72448_b, this.ritual.secondaryColor.field_72449_c);
                }
                if (this.random.nextInt(2) == 0) {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(60.0 + 360.0 * (double)(this.progress % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(60.0 + 360.0 * (double)(this.progress % 100) / 100.0)), this.ritual.color.field_72450_a, this.ritual.color.field_72448_b, this.ritual.color.field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(60.0 + 360.0 * (double)(this.progress % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(60.0 + 360.0 * (double)(this.progress % 100) / 100.0)), this.ritual.secondaryColor.field_72450_a, this.ritual.secondaryColor.field_72448_b, this.ritual.secondaryColor.field_72449_c);
                }
                if (this.random.nextInt(2) == 0) {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(120.0 + 360.0 * (double)(this.progress % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(120.0 + 360.0 * (double)(this.progress % 100) / 100.0)), this.ritual.color.field_72450_a, this.ritual.color.field_72448_b, this.ritual.color.field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(120.0 + 360.0 * (double)(this.progress % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(120.0 + 360.0 * (double)(this.progress % 100) / 100.0)), this.ritual.secondaryColor.field_72450_a, this.ritual.secondaryColor.field_72448_b, this.ritual.secondaryColor.field_72449_c);
                }
                if (this.random.nextInt(2) == 0) {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(180.0 + 360.0 * (double)(this.progress % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(180.0 + 360.0 * (double)(this.progress % 100) / 100.0)), this.ritual.color.field_72450_a, this.ritual.color.field_72448_b, this.ritual.color.field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(180.0 + 360.0 * (double)(this.progress % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(180.0 + 360.0 * (double)(this.progress % 100) / 100.0)), this.ritual.secondaryColor.field_72450_a, this.ritual.secondaryColor.field_72448_b, this.ritual.secondaryColor.field_72449_c);
                }
                if (this.random.nextInt(2) == 0) {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(240.0 + 360.0 * (double)(this.progress % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(240.0 + 360.0 * (double)(this.progress % 100) / 100.0)), this.ritual.color.field_72450_a, this.ritual.color.field_72448_b, this.ritual.color.field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(240.0 + 360.0 * (double)(this.progress % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(240.0 + 360.0 * (double)(this.progress % 100) / 100.0)), this.ritual.secondaryColor.field_72450_a, this.ritual.secondaryColor.field_72448_b, this.ritual.secondaryColor.field_72449_c);
                }
                if (this.random.nextInt(2) == 0) {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(300.0 + 360.0 * (double)(this.progress % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(300.0 + 360.0 * (double)(this.progress % 100) / 100.0)), this.ritual.color.field_72450_a, this.ritual.color.field_72448_b, this.ritual.color.field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(300.0 + 360.0 * (double)(this.progress % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(300.0 + 360.0 * (double)(this.progress % 100) / 100.0)), this.ritual.secondaryColor.field_72450_a, this.ritual.secondaryColor.field_72448_b, this.ritual.secondaryColor.field_72449_c);
                }
            }
            if (this.progress % 40 == 0) {
                this.incenses = RitualManager.getIncenses(this.func_145831_w(), this.func_174877_v());
                boolean doesMatch = false;
                for (int i = 0; i < RitualManager.rituals.size(); ++i) {
                    if (!RitualManager.rituals.get(i).matches(this.func_145831_w(), this.func_174877_v())) continue;
                    doesMatch = true;
                }
                if (!doesMatch) {
                    this.ritual = null;
                    this.ritualName = null;
                }
            }
            if (this.progress == 0 && this.ritual != null) {
                this.ritual.doEffect(this.func_145831_w(), this.func_174877_v(), this.inventory, this.incenses);
                this.ritualName = null;
                this.ritual = null;
                this.func_70296_d();
                this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            }
        }
    }
}

