/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.registry.focusablejson;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.valkyrieofnight.environmentaltech.api.registry.IFocusableRegistry;
import com.valkyrieofnight.environmentaltech.api.util.WeightedItemStack;
import com.valkyrieofnight.environmentaltech.api.util.WeightedOreStack;
import com.valkyrieofnight.environmentaltech.api.util.WeightedStackBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FocusableJsonHandler {
    public static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void saveRegistryDefaultsToJson(File file, FocusableList defaults) {
        try {
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            writer.write(gson.toJson((Object)defaults));
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FocusableList loadRegistryFromJson(File file, IFocusableRegistry registry) {
        FocusableList loaded = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            if (reader.ready()) {
                loaded = (FocusableList)gson.fromJson((Reader)reader, FocusableList.class);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (loaded != null) {
            FocusableJsonHandler.loadIntoRegistry(loaded, registry);
        }
        return loaded;
    }

    public static void loadIntoRegistry(FocusableList entries, IFocusableRegistry registry) {
        if (entries == null || registry == null) {
            return;
        }
        ArrayList<FocusableEntry> el = entries.getEntries();
        if (el == null) {
            return;
        }
        for (FocusableEntry entry : el) {
            WeightedStackBase ws = entry.getRegistryEntry();
            if (ws.getMainStack() == null || ws.getMainStack().func_77973_b() == null || ws.getMainStack().field_77994_a <= 0 || ws.getWeight() <= 0) continue;
            EnumDyeColor preferred = entry.getFocusColor();
            if (ws == null || preferred == null) continue;
            registry.addResource(ws, preferred);
        }
    }

    public static class FocusableBlock
    extends FocusableEntry {
        public String id;
        public int meta;
        public EnumFocusColor focusColor;
        public int weight;

        public FocusableBlock() {
        }

        public FocusableBlock(String id, int meta, EnumDyeColor focusColor, int weight) {
            this.id = id;
            this.meta = meta;
            this.focusColor = EnumFocusColor.getFromDye(focusColor);
            this.weight = weight;
        }

        @Override
        public WeightedStackBase getRegistryEntry() {
            if (Strings.isNullOrEmpty((String)this.id) || this.meta < 0 || this.weight <= 0) {
                return null;
            }
            Block blk = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(this.id));
            if (blk == null) {
                return null;
            }
            return new WeightedItemStack(new ItemStack(blk, 1, this.meta), this.weight);
        }

        @Override
        public EnumDyeColor getFocusColor() {
            return this.focusColor.getColor();
        }

        public String getIDWithMeta() {
            return this.id + ":" + this.meta;
        }
    }

    public static class FocusableItem
    extends FocusableEntry {
        public String id;
        public int meta;
        public EnumFocusColor focusColor;
        public int weight;

        public FocusableItem() {
        }

        public FocusableItem(String id, int meta, EnumDyeColor focusColor, int weight) {
            this.id = id;
            this.meta = meta;
            this.focusColor = EnumFocusColor.getFromDye(focusColor);
            this.weight = weight;
        }

        @Override
        public WeightedStackBase getRegistryEntry() {
            if (Strings.isNullOrEmpty((String)this.id) || this.meta < 0 || this.weight <= 0) {
                return null;
            }
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.id));
            if (item == null) {
                return null;
            }
            return new WeightedItemStack(new ItemStack(item, 1, this.meta), this.weight);
        }

        @Override
        public EnumDyeColor getFocusColor() {
            return this.focusColor.getColor();
        }

        public String getIDWithMeta() {
            return this.id + ":" + this.meta;
        }
    }

    public static class FocusableOre
    extends FocusableEntry {
        public String oreName;
        public EnumFocusColor focusColor;
        public int weight;

        public FocusableOre() {
        }

        public FocusableOre(String ore, EnumDyeColor focusColor, int weight) {
            this.oreName = ore;
            this.focusColor = EnumFocusColor.getFromDye(focusColor);
            this.weight = weight;
        }

        @Override
        public WeightedStackBase getRegistryEntry() {
            if (Strings.isNullOrEmpty((String)this.oreName) || this.weight <= 0) {
                return null;
            }
            return new WeightedOreStack(this.oreName, this.weight);
        }

        @Override
        public EnumDyeColor getFocusColor() {
            return this.focusColor.getColor();
        }

        public String getOreName() {
            return this.oreName;
        }
    }

    public static abstract class FocusableEntry {
        public abstract WeightedStackBase getRegistryEntry();

        public abstract EnumDyeColor getFocusColor();
    }

    public static enum FocusableType {
        ORE,
        ITEM,
        BLOCK;

    }

    public static enum EnumFocusColor {
        WHITE(EnumDyeColor.WHITE),
        ORANGE(EnumDyeColor.ORANGE),
        MAGENTA(EnumDyeColor.MAGENTA),
        LIGHT_BLUE(EnumDyeColor.LIGHT_BLUE),
        YELLOW(EnumDyeColor.YELLOW),
        LIME(EnumDyeColor.LIME),
        PINK(EnumDyeColor.PINK),
        GRAY(EnumDyeColor.GRAY),
        SILVER(EnumDyeColor.SILVER),
        CYAN(EnumDyeColor.CYAN),
        PURPLE(EnumDyeColor.PURPLE),
        BLUE(EnumDyeColor.BLUE),
        BROWN(EnumDyeColor.BROWN),
        GREEN(EnumDyeColor.GREEN),
        RED(EnumDyeColor.RED),
        BLACK(EnumDyeColor.BLACK);

        private final EnumDyeColor dyeColor;

        private EnumFocusColor(EnumDyeColor color) {
            this.dyeColor = color;
        }

        public EnumDyeColor getColor() {
            return this.dyeColor;
        }

        public static EnumFocusColor getFromDye(EnumDyeColor dye) {
            for (EnumFocusColor focus : EnumFocusColor.values()) {
                if (focus.getColor() != dye) continue;
                return focus;
            }
            return WHITE;
        }
    }

    public static class FocusableList {
        private ArrayList<FocusableItem> items = new ArrayList();
        private ArrayList<FocusableBlock> blocks = new ArrayList();
        private ArrayList<FocusableOre> oreDict = new ArrayList();

        public ArrayList<FocusableEntry> getEntries() {
            return new ArrayList<FocusableEntry>(){
                {
                    this.addAll(items);
                    this.addAll(blocks);
                    this.addAll(oreDict);
                }
            };
        }

        public void addEntry(FocusableItem itm) {
            this.items.add(itm);
        }

        public void addEntry(FocusableBlock blk) {
            this.blocks.add(blk);
        }

        public void addEntry(FocusableOre od) {
            this.oreDict.add(od);
        }

        public boolean hasEntry(FocusableItem itm) {
            if (itm == null) {
                return false;
            }
            for (FocusableItem fi : this.items) {
                if (fi == null || !fi.getIDWithMeta().equalsIgnoreCase(itm.getIDWithMeta())) continue;
                return true;
            }
            return false;
        }

        public boolean hasEntry(FocusableBlock blk) {
            if (blk == null) {
                return false;
            }
            for (FocusableBlock fi : this.blocks) {
                if (fi == null || !fi.getIDWithMeta().equalsIgnoreCase(blk.getIDWithMeta())) continue;
                return true;
            }
            return false;
        }

        public boolean hasEntry(FocusableOre od) {
            if (od == null) {
                return false;
            }
            for (FocusableOre fi : this.oreDict) {
                if (fi == null || !fi.getOreName().equalsIgnoreCase(od.getOreName())) continue;
                return true;
            }
            return false;
        }
    }
}

