/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.network.packets;

import com.valkyrieofnight.environmentaltech.tileentity.multiblock.voidminer.TileContVoidMinerBase;
import com.valkyrieofnight.valkyrielib.network.VLPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class VoidMinerUpdatePacket
extends VLPacket<VoidMinerUpdatePacket> {
    protected int x;
    protected int y;
    protected int z;
    protected boolean canMine;
    protected boolean canSeeVoid;
    protected boolean formed;
    protected boolean processing;
    protected boolean clearLens;
    protected int energyLevel;

    public VoidMinerUpdatePacket() {
    }

    public VoidMinerUpdatePacket(TileContVoidMinerBase tile) {
        this.x = tile.func_174877_v().func_177958_n();
        this.y = tile.func_174877_v().func_177956_o();
        this.z = tile.func_174877_v().func_177952_p();
        this.canMine = tile.getCanMine();
        this.canSeeVoid = tile.canSeeVoid();
        this.formed = tile.isFormed();
        this.processing = tile.isProcessing();
        this.energyLevel = tile.getEnergyReceiver().getEnergyStored();
        this.clearLens = !tile.isLensColored();
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.canMine = buf.readBoolean();
        this.canSeeVoid = buf.readBoolean();
        this.formed = buf.readBoolean();
        this.processing = buf.readBoolean();
        this.energyLevel = buf.readInt();
        this.clearLens = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeBoolean(this.canMine);
        buf.writeBoolean(this.canSeeVoid);
        buf.writeBoolean(this.formed);
        buf.writeBoolean(this.processing);
        buf.writeInt(this.energyLevel);
        buf.writeBoolean(this.clearLens);
    }

    public IMessage onMessage(VoidMinerUpdatePacket msg, MessageContext ctx) {
        TileEntity te;
        if (ctx.getClientHandler() != null && (te = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175625_s(new BlockPos(msg.x, msg.y, msg.z))) instanceof TileContVoidMinerBase) {
            TileContVoidMinerBase tvm = (TileContVoidMinerBase)te;
            tvm.packetUpdate(msg.canMine, msg.canSeeVoid, msg.energyLevel, msg.clearLens);
            tvm.clientPacketUpdate(msg.formed, msg.processing, 0, 0);
        }
        return null;
    }
}

