/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.block.multiblock.structure;

import com.valkyrieofnight.environmentaltech.EnvironmentalTech;
import com.valkyrieofnight.environmentaltech.api.block.EnumStructureBlock;
import com.valkyrieofnight.environmentaltech.api.block.IEnumStructureBlock;
import com.valkyrieofnight.environmentaltech.item.ItemStructureBlock;
import com.valkyrieofnight.valkyrielib.block.IBlockWithMeta;
import com.valkyrieofnight.valkyrielib.block.IEnumBlockWithMeta;
import com.valkyrieofnight.valkyrielib.multiblock.VLTileSlave;
import com.valkyrieofnight.valkyrielib.multiblock.block.VLBlockSlave;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStructure
extends VLBlockSlave
implements IBlockWithMeta,
IEnumStructureBlock {
    public static final PropertyEnum<EnumStructureBlock> TIER = PropertyEnum.func_177709_a((String)"tier", EnumStructureBlock.class);
    private String modBase;

    public BlockStructure(String blockName, Material mat, float hardness, float resistance) {
        super("environmentaltech", blockName, mat, hardness, resistance, EnvironmentalTech.creativeTab, null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TIER, (Comparable)((Object)EnumStructureBlock.TIER_1)));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new VLTileSlave();
    }

    public void register() {
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemStructureBlock((Block)this), (ResourceLocation)this.getRegistryName());
    }

    public void registerTile() {
        String[] alts = new String[EnumStructureBlock.values().length - 1];
        for (EnumStructureBlock type : EnumStructureBlock.values()) {
            if (type.getMetadata() == 0) continue;
            alts[type.getMetadata() - 1] = this.getRegistryName() + "." + type.func_176610_l() + ".tile";
        }
        GameRegistry.registerTileEntityWithAlternatives(VLTileSlave.class, (String)(this.getRegistryName() + ".tile"), (String[])alts);
    }

    public void initModel() {
        for (EnumStructureBlock type : EnumStructureBlock.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_" + type.func_176610_l(), "inventory"));
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumStructureBlock)((Object)state.func_177229_b(TIER))).getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (EnumStructureBlock type : EnumStructureBlock.values()) {
            list.add(new ItemStack(itemIn, 1, type.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TIER, (Comparable)((Object)EnumStructureBlock.getFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumStructureBlock)((Object)state.func_177229_b(TIER))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TIER});
    }

    public String getSpecialName(ItemStack stack) {
        return EnumStructureBlock.getFromMeta(stack.func_77952_i()).func_176610_l();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult ray, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public IEnumBlockWithMeta getSubType(int meta) {
        return EnumStructureBlock.getFromMeta(meta);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public EnumStructureBlock getStructureTier(int meta) {
        return EnumStructureBlock.getFromMeta(meta);
    }
}

