/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.Argument;
import mcjty.lib.network.ArgumentType;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.tools.ItemStackTools;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AbstractServerCommand
implements IMessage {
    protected BlockPos pos;
    protected Integer dimensionId;
    protected String command;
    protected Map<String, Argument> args;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos(buf);
        this.command = NetworkTools.readString(buf);
        this.args = AbstractServerCommand.readArguments(buf);
        this.dimensionId = buf.readBoolean() ? Integer.valueOf(buf.readInt()) : null;
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos(buf, this.pos);
        NetworkTools.writeString(buf, this.command);
        AbstractServerCommand.writeArguments(buf, this.args);
        if (this.dimensionId != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.dimensionId.intValue());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static Map<String, Argument> readArguments(ByteBuf buf) {
        HashMap<String, Argument> args;
        int size = buf.readInt();
        if (size == 0) {
            args = null;
        } else {
            args = new HashMap<String, Argument>(size);
            block8: for (int i = 0; i < size; ++i) {
                String key = NetworkTools.readString(buf);
                ArgumentType type = ArgumentType.getType(buf.readByte());
                switch (type) {
                    case TYPE_STRING: {
                        args.put(key, new Argument(key, NetworkTools.readString(buf)));
                        continue block8;
                    }
                    case TYPE_INTEGER: {
                        args.put(key, new Argument(key, buf.readInt()));
                        continue block8;
                    }
                    case TYPE_BLOCKPOS: {
                        int cx = buf.readInt();
                        int cy = buf.readInt();
                        int cz = buf.readInt();
                        if (cx == -1 && cy == -1 && cz == -1) {
                            args.put(key, new Argument(key, (BlockPos)null));
                            continue block8;
                        }
                        args.put(key, new Argument(key, new BlockPos(cx, cy, cz)));
                        continue block8;
                    }
                    case TYPE_BOOLEAN: {
                        args.put(key, new Argument(key, buf.readByte() == 1));
                        continue block8;
                    }
                    case TYPE_DOUBLE: {
                        args.put(key, new Argument(key, buf.readDouble()));
                        continue block8;
                    }
                    case TYPE_STACK: {
                        if (buf.readBoolean()) {
                            args.put(key, new Argument(key, NetworkTools.readItemStack(buf)));
                            continue block8;
                        }
                        args.put(key, new Argument(key, ItemStackTools.getEmptyStack()));
                    }
                }
            }
        }
        return args;
    }

    public static void writeArguments(ByteBuf buf, Map<String, Argument> args) {
        if (args == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(args.size());
            for (Argument arg : args.values()) {
                String key = arg.getName();
                NetworkTools.writeString(buf, key);
                buf.writeByte(arg.getType().getIndex());
                switch (arg.getType()) {
                    case TYPE_STRING: {
                        NetworkTools.writeString(buf, arg.getString());
                        break;
                    }
                    case TYPE_INTEGER: {
                        buf.writeInt(arg.getInteger().intValue());
                        break;
                    }
                    case TYPE_BLOCKPOS: {
                        BlockPos c = arg.getCoordinate();
                        if (c == null) {
                            buf.writeInt(-1);
                            buf.writeInt(-1);
                            buf.writeInt(-1);
                            break;
                        }
                        buf.writeInt(c.func_177958_n());
                        buf.writeInt(c.func_177956_o());
                        buf.writeInt(c.func_177952_p());
                        break;
                    }
                    case TYPE_BOOLEAN: {
                        buf.writeByte(arg.getBoolean() ? 1 : 0);
                        break;
                    }
                    case TYPE_DOUBLE: {
                        buf.writeDouble(arg.getDouble().doubleValue());
                        break;
                    }
                    case TYPE_STACK: {
                        if (ItemStackTools.isEmpty((ItemStack)arg.getStack())) {
                            buf.writeBoolean(false);
                            break;
                        }
                        buf.writeBoolean(true);
                        NetworkTools.writeItemStack(buf, arg.getStack());
                    }
                }
            }
        }
    }

    protected AbstractServerCommand() {
    }

    protected AbstractServerCommand(BlockPos pos, String command, Argument ... arguments) {
        this.pos = pos;
        this.command = command;
        if (arguments == null) {
            this.args = null;
        } else {
            this.args = new HashMap<String, Argument>(arguments.length);
            for (Argument arg : arguments) {
                this.args.put(arg.getName(), arg);
            }
        }
    }
}

