/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.EnumFacing;

public class EnergyBar
extends AbstractWidget<EnergyBar> {
    private int value;
    private int maxValue;
    private int energyOnColor = StyleConfig.colorEnergyBarHighEnergy;
    private int energyOffColor = StyleConfig.colorEnergyBarLowEnergy;
    private int spacerColor = StyleConfig.colorEnergyBarSpacer;
    private int textColor = StyleConfig.colorEnergyBarText;
    private boolean horizontal = false;
    private IEnergyHandler handler = null;
    private boolean showText = true;
    private boolean showRfPerTick = false;
    private int rfPerTick = 0;

    public EnergyBar(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public EnergyBar setHorizontal() {
        this.horizontal = true;
        return this;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public EnergyBar setHandler(IEnergyHandler handler) {
        this.handler = handler;
        return this;
    }

    public IEnergyHandler getHandler() {
        return this.handler;
    }

    public EnergyBar setVertical() {
        this.horizontal = false;
        return this;
    }

    public boolean isVertical() {
        return !this.horizontal;
    }

    @Override
    public List<String> getTooltips() {
        if (this.tooltips == null) {
            String s = this.getValue() + " / " + this.getMaxValue();
            ArrayList<String> tt = new ArrayList<String>();
            tt.add(s);
            return tt;
        }
        return this.tooltips;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public EnergyBar setShowText(boolean showText) {
        this.showText = showText;
        return this;
    }

    public boolean isShowRfPerTick() {
        return this.showRfPerTick;
    }

    public EnergyBar setShowRfPerTick(boolean showRfPerTick) {
        this.showRfPerTick = showRfPerTick;
        return this;
    }

    public int getRfPerTick() {
        return this.rfPerTick;
    }

    public EnergyBar setRfPerTick(int rfPerTick) {
        this.rfPerTick = rfPerTick;
        return this;
    }

    public int getValue() {
        if (this.handler != null) {
            return this.handler.getEnergyStored(EnumFacing.DOWN);
        }
        return this.value;
    }

    public EnergyBar setValue(int value) {
        this.value = value;
        return this;
    }

    public int getMaxValue() {
        if (this.handler != null) {
            return this.handler.getMaxEnergyStored(EnumFacing.DOWN);
        }
        return this.maxValue;
    }

    public EnergyBar setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public int getEnergyOnColor() {
        return this.energyOnColor;
    }

    public EnergyBar setEnergyOnColor(int energyOnColor) {
        this.energyOnColor = energyOnColor;
        return this;
    }

    public int getEnergyOffColor() {
        return this.energyOffColor;
    }

    public EnergyBar setEnergyOffColor(int leftColor) {
        this.energyOffColor = leftColor;
        return this;
    }

    public int getSpacerColor() {
        return this.spacerColor;
    }

    public EnergyBar setSpacerColor(int rightColor) {
        this.spacerColor = rightColor;
        return this;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public EnergyBar setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        super.draw(window, x, y);
        int bx = x + this.bounds.x;
        int by = y + this.bounds.y;
        RenderHelper.drawThickBeveledBox(bx, by, bx + this.bounds.width - 1, by + this.bounds.height - 1, 1, StyleConfig.colorEnergyBarTopLeft, StyleConfig.colorEnergyBarBottomRight, -10263709);
        int currentValue = this.getValue();
        int maximum = this.getMaxValue();
        if (maximum > 0) {
            int color;
            boolean on = false;
            if (this.horizontal) {
                int w = (int)((float)(this.bounds.width - 2) * (float)currentValue / (float)maximum);
                for (int xx = bx + 1; xx < bx + this.bounds.width - 2; ++xx) {
                    color = this.getColor(bx, w, on, xx);
                    RenderHelper.drawVerticalLine(xx, by + 1, by + this.bounds.height - 2, color);
                    on = !on;
                }
            } else {
                int h = (int)((float)(this.bounds.height - 2) * (float)currentValue / (float)maximum);
                for (int yy = y + 1; yy < y + this.bounds.height - 2; ++yy) {
                    color = this.getColorReversed(y, h, on, yy);
                    RenderHelper.drawHorizontalLine(bx + 1, y + by + this.bounds.height - yy - 2, bx + this.bounds.width - 2, color);
                    on = !on;
                }
            }
        }
        if (this.showText) {
            String s = this.showRfPerTick ? this.rfPerTick + "RF/t" : currentValue + "/" + maximum;
            this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(s, this.getBounds().width), x + this.bounds.x + 5, y + this.bounds.y + (this.bounds.height - this.mc.field_71466_p.field_78288_b) / 2, this.textColor);
        }
    }

    private int getColor(int pos, int total, boolean on, int cur) {
        int color = on ? (cur < pos + total ? this.energyOnColor : this.energyOffColor) : this.spacerColor;
        return color;
    }

    private int getColorReversed(int pos, int total, boolean on, int cur) {
        int color = on ? (cur < pos + total ? this.energyOnColor : this.energyOffColor) : this.spacerColor;
        return color;
    }
}

