/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import com.google.common.collect.Range;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.CraftingSlot;
import mcjty.lib.container.GenericCrafter;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.container.GhostSlot;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotRanges;
import mcjty.lib.container.SlotType;
import mcjty.lib.network.PacketSendGuiData;
import mcjty.lib.tools.InventoryTools;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class GenericContainer
extends Container {
    protected Map<String, IInventory> inventories = new HashMap<String, IInventory>();
    private ContainerFactory factory;
    private GenericCrafter crafter = null;

    public GenericContainer(ContainerFactory factory) {
        this.factory = factory;
    }

    public void addInventory(String name, IInventory inventory) {
        this.inventories.put(name, inventory);
    }

    public IInventory getInventory(String name) {
        return this.inventories.get(name);
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        for (IInventory inventory : this.inventories.values()) {
            if (InventoryTools.isUsable((EntityPlayer)entityPlayer, (IInventory)inventory)) continue;
            return false;
        }
        return true;
    }

    public SlotType getSlotType(int index) {
        return this.factory.getSlotType(index);
    }

    public GenericCrafter getCrafter() {
        return this.crafter;
    }

    public void setCrafter(GenericCrafter crafter) {
        this.crafter = crafter;
    }

    public void generateSlots() {
        for (SlotFactory slotFactory : this.factory.getSlots()) {
            IInventory inventory = this.inventories.get(slotFactory.getInventoryName());
            int index = slotFactory.getIndex();
            int x = slotFactory.getX();
            int y = slotFactory.getY();
            SlotType slotType = slotFactory.getSlotType();
            Slot slot = this.createSlot(slotFactory, inventory, index, x, y, slotType);
            this.func_75146_a(slot);
        }
    }

    protected Slot createSlot(SlotFactory slotFactory, IInventory inventory, int index, int x, int y, SlotType slotType) {
        Object slot;
        if (slotType == SlotType.SLOT_GHOST) {
            slot = new GhostSlot(inventory, index, x, y);
        } else if (slotType == SlotType.SLOT_GHOSTOUT) {
            slot = new GhostOutputSlot(inventory, index, x, y);
        } else if (slotType == SlotType.SLOT_SPECIFICITEM) {
            final SlotDefinition slotDefinition = slotFactory.getSlotDefinition();
            slot = new Slot(inventory, index, x, y){

                public boolean func_75214_a(ItemStack stack) {
                    return slotDefinition.itemStackMatches(stack);
                }
            };
        } else {
            slot = slotType == SlotType.SLOT_CRAFTRESULT ? new CraftingSlot(inventory, index, x, y, this.crafter) : new BaseSlot(inventory, index, x, y);
        }
        return slot;
    }

    private boolean mergeItemStacks(ItemStack itemStack, int sourceSlot, SlotType slotType, boolean reverse) {
        if (slotType == SlotType.SLOT_SPECIFICITEM) {
            for (SlotDefinition definition : this.factory.getSlotRangesMap().keySet()) {
                if (!slotType.equals((Object)definition.getType()) || !this.mergeItemStacks(itemStack, sourceSlot, definition, reverse)) continue;
                return true;
            }
            return false;
        }
        return this.mergeItemStacks(itemStack, sourceSlot, new SlotDefinition(slotType, new ItemStack[0]), reverse);
    }

    protected boolean mergeItemStacks(ItemStack itemStack, int sourceSlot, SlotDefinition slotDefinition, boolean reverse) {
        SlotRanges ranges = this.factory.getSlotRangesMap().get(slotDefinition);
        if (ranges == null) {
            return false;
        }
        SlotType slotType = slotDefinition.getType();
        if (itemStack.func_77973_b() != null && slotType == SlotType.SLOT_SPECIFICITEM && !slotDefinition.itemStackMatches(itemStack)) {
            return false;
        }
        for (Range<Integer> r : ranges.asRanges()) {
            Integer start = (Integer)r.lowerEndpoint();
            int end = (Integer)r.upperEndpoint();
            if (!this.func_75135_a(itemStack, start, end, reverse)) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStackTools.getEmptyStack();
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack origStack = slot.func_75211_c();
            itemstack = origStack.func_77946_l();
            if (this.factory.isSpecificItemSlot(index)) {
                if (!this.mergeItemStacks(origStack, index, SlotType.SLOT_PLAYERINV, true) && !this.mergeItemStacks(origStack, index, SlotType.SLOT_PLAYERHOTBAR, false)) {
                    return ItemStackTools.getEmptyStack();
                }
                slot.func_75220_a(origStack, itemstack);
            } else if (this.factory.isOutputSlot(index) || this.factory.isInputSlot(index) || this.factory.isContainerSlot(index)) {
                if (!(this.mergeItemStacks(origStack, index, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, index, SlotType.SLOT_PLAYERINV, true) || this.mergeItemStacks(origStack, index, SlotType.SLOT_PLAYERHOTBAR, false))) {
                    return ItemStackTools.getEmptyStack();
                }
                slot.func_75220_a(origStack, itemstack);
            } else {
                if (this.factory.isGhostSlot(index) || this.factory.isGhostOutputSlot(index)) {
                    return ItemStackTools.getEmptyStack();
                }
                if (this.factory.isPlayerInventorySlot(index)) {
                    if (!(this.mergeItemStacks(origStack, index, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, index, SlotType.SLOT_INPUT, false) || this.mergeItemStacks(origStack, index, SlotType.SLOT_PLAYERHOTBAR, false))) {
                        return ItemStackTools.getEmptyStack();
                    }
                } else if (this.factory.isPlayerHotbarSlot(index)) {
                    if (!(this.mergeItemStacks(origStack, index, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, index, SlotType.SLOT_INPUT, false) || this.mergeItemStacks(origStack, index, SlotType.SLOT_PLAYERINV, false))) {
                        return ItemStackTools.getEmptyStack();
                    }
                } else {
                    Logging.log("Weird slot at index: " + index);
                }
            }
            if (ItemStackTools.isEmpty((ItemStack)origStack)) {
                slot.func_75215_d(ItemStackTools.getEmptyStack());
            } else {
                slot.func_75218_e();
            }
            if (ItemStackTools.getStackSize((ItemStack)origStack) == ItemStackTools.getStackSize((ItemStack)itemstack)) {
                return ItemStackTools.getEmptyStack();
            }
            InventoryTools.onPickup((Slot)slot, (EntityPlayer)player, (ItemStack)origStack);
        }
        return itemstack;
    }

    protected boolean func_75135_a(ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reverseOrder) {
        Slot slot;
        boolean result = false;
        int checkIndex = fromIndex;
        if (reverseOrder) {
            checkIndex = toIndex - 1;
        }
        ItemStack itemstack1 = ItemStackTools.getEmptyStack();
        if (par1ItemStack.func_77985_e()) {
            while (ItemStackTools.isValid((ItemStack)par1ItemStack) && (!reverseOrder && checkIndex < toIndex || reverseOrder && checkIndex >= fromIndex)) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (ItemStackTools.isValid((ItemStack)itemstack1) && itemstack1.func_77973_b() == par1ItemStack.func_77973_b() && (!par1ItemStack.func_77981_g() || par1ItemStack.func_77952_i() == itemstack1.func_77952_i()) && ItemStack.func_77970_a((ItemStack)par1ItemStack, (ItemStack)itemstack1) && slot.func_75214_a(par1ItemStack)) {
                    int maxStackSize;
                    int mergedSize = ItemStackTools.getStackSize((ItemStack)itemstack1) + ItemStackTools.getStackSize((ItemStack)par1ItemStack);
                    if (mergedSize <= (maxStackSize = Math.min(par1ItemStack.func_77976_d(), slot.func_75219_a()))) {
                        ItemStackTools.makeEmpty((ItemStack)par1ItemStack);
                        ItemStackTools.setStackSize((ItemStack)itemstack1, (int)mergedSize);
                        slot.func_75218_e();
                        result = true;
                    } else if (ItemStackTools.getStackSize((ItemStack)itemstack1) < maxStackSize) {
                        ItemStackTools.incStackSize((ItemStack)par1ItemStack, (int)(-(maxStackSize - ItemStackTools.getStackSize((ItemStack)itemstack1))));
                        ItemStackTools.setStackSize((ItemStack)itemstack1, (int)maxStackSize);
                        slot.func_75218_e();
                        result = true;
                    }
                }
                if (reverseOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        if (ItemStackTools.isValid((ItemStack)par1ItemStack)) {
            checkIndex = reverseOrder ? toIndex - 1 : fromIndex;
            while (!reverseOrder && checkIndex < toIndex || reverseOrder && checkIndex >= fromIndex) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (ItemStackTools.isEmpty((ItemStack)itemstack1) && slot.func_75214_a(par1ItemStack)) {
                    ItemStack in = par1ItemStack.func_77946_l();
                    ItemStackTools.setStackSize((ItemStack)in, (int)Math.min(ItemStackTools.getStackSize((ItemStack)in), slot.func_75219_a()));
                    slot.func_75215_d(in);
                    slot.func_75218_e();
                    if (ItemStackTools.getStackSize((ItemStack)in) >= ItemStackTools.getStackSize((ItemStack)par1ItemStack)) {
                        ItemStackTools.makeEmpty((ItemStack)par1ItemStack);
                    } else {
                        ItemStackTools.incStackSize((ItemStack)par1ItemStack, (int)(-ItemStackTools.getStackSize((ItemStack)in)));
                    }
                    result = true;
                    break;
                }
                if (reverseOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        return result;
    }

    public ItemStack func_184996_a(int index, int button, ClickType mode, EntityPlayer player) {
        if (this.factory.isGhostSlot(index)) {
            ItemStack clickedWith;
            Slot slot = this.func_75139_a(index);
            if (slot.func_75216_d()) {
                slot.func_75215_d(ItemStackTools.getEmptyStack());
            }
            if (ItemStackTools.isValid((ItemStack)(clickedWith = player.field_71071_by.func_70445_o()))) {
                ItemStack copy = clickedWith.func_77946_l();
                ItemStackTools.setStackSize((ItemStack)copy, (int)1);
                slot.func_75215_d(copy);
            }
            this.func_75142_b();
            return ItemStackTools.getEmptyStack();
        }
        return super.func_184996_a(index, button, mode, player);
    }

    protected void notifyPlayerOfChanges(SimpleNetworkWrapper wrapper, World world, BlockPos pos) {
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)listener;
            wrapper.sendTo((IMessage)new PacketSendGuiData(world, pos), player);
        }
    }
}

