/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.ranged.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;

public class BoltCore
extends ToolPart {
    public static ItemStack GUI_RENDER_ITEMSTACK;

    public BoltCore(int cost) {
        super(cost);
    }

    @Override
    public Material getMaterial(ItemStack stack) {
        NBTTagList materials = TagUtil.getBaseMaterialsTagList(stack);
        return TinkerRegistry.getMaterial(materials.func_150307_f(0));
    }

    public static Material getHeadMaterial(ItemStack stack) {
        NBTTagList materials = TagUtil.getBaseMaterialsTagList(stack);
        return TinkerRegistry.getMaterial(materials.func_150307_f(1));
    }

    @Override
    public ItemStack getItemstackWithMaterial(Material material) {
        if (material.hasStats("shaft")) {
            return BoltCore.getItemstackWithMaterials(material, TinkerMaterials.iron);
        }
        return BoltCore.getItemstackWithMaterials(TinkerMaterials.wood, material);
    }

    public static ItemStack getItemstackWithMaterials(Material shaft, Material head) {
        ItemStack stack = new ItemStack((Item)TinkerTools.boltCore);
        NBTTagList tagList = new NBTTagList();
        tagList.func_74742_a((NBTBase)new NBTTagString(shaft.getIdentifier()));
        tagList.func_74742_a((NBTBase)new NBTTagString(head.getIdentifier()));
        NBTTagCompound rootTag = new NBTTagCompound();
        NBTTagCompound baseTag = new NBTTagCompound();
        baseTag.func_74782_a("Materials", (NBTBase)tagList);
        rootTag.func_74782_a("TinkerData", (NBTBase)baseTag);
        stack.func_77982_d(rootTag);
        return stack;
    }

    public static ItemStack getHeadStack(ItemStack boltCore) {
        return BoltCore.getItemstackWithMaterials(BoltCore.getHeadMaterial(boltCore), Material.UNKNOWN);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        Material material = this.getMaterial(stack);
        Material material2 = BoltCore.getHeadMaterial(stack);
        boolean shift = Util.isShiftKeyDown();
        if (!this.checkMissingMaterialTooltip(stack, tooltip)) {
            tooltip.addAll(this.getTooltipTraitInfo(material));
            tooltip.addAll(this.getTooltipTraitInfo(material2));
        }
        if (Config.extraTooltips) {
            if (!shift) {
                tooltip.add("");
                tooltip.add(Util.translate("tooltip.tool.holdShift", new Object[0]));
            } else {
                tooltip.addAll(this.getTooltipStatsInfo(material));
                tooltip.addAll(this.getTooltipStatsInfo(material2));
            }
        }
        tooltip.addAll(this.getAddedByInfo(material2));
    }

    @Override
    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        Material material = this.getMaterial(stack);
        Material material2 = BoltCore.getHeadMaterial(stack);
        String originalItemName = ("" + I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
        return Material.getCombinedItemName(originalItemName, (Collection<Material>)ImmutableList.of((Object)((Object)material), (Object)((Object)material2)));
    }

    @Override
    public boolean canBeCrafted() {
        return false;
    }

    @Override
    public boolean canBeCasted() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getOutlineRenderStack() {
        if (GUI_RENDER_ITEMSTACK == null) {
            GUI_RENDER_ITEMSTACK = BoltCore.getItemstackWithMaterials(CustomTextureCreator.guiMaterial, CustomTextureCreator.guiMaterial);
        }
        return GUI_RENDER_ITEMSTACK;
    }
}

