/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.AbstractToolPulse;
import slimeknights.tconstruct.tools.modifiers.ModAntiMonsterType;
import slimeknights.tconstruct.tools.modifiers.ModBeheading;
import slimeknights.tconstruct.tools.modifiers.ModBlasting;
import slimeknights.tconstruct.tools.modifiers.ModCreative;
import slimeknights.tconstruct.tools.modifiers.ModDiamond;
import slimeknights.tconstruct.tools.modifiers.ModEmerald;
import slimeknights.tconstruct.tools.modifiers.ModFiery;
import slimeknights.tconstruct.tools.modifiers.ModFins;
import slimeknights.tconstruct.tools.modifiers.ModFortify;
import slimeknights.tconstruct.tools.modifiers.ModGlowing;
import slimeknights.tconstruct.tools.modifiers.ModHarvestSize;
import slimeknights.tconstruct.tools.modifiers.ModHaste;
import slimeknights.tconstruct.tools.modifiers.ModKnockback;
import slimeknights.tconstruct.tools.modifiers.ModLuck;
import slimeknights.tconstruct.tools.modifiers.ModMendingMoss;
import slimeknights.tconstruct.tools.modifiers.ModNecrotic;
import slimeknights.tconstruct.tools.modifiers.ModReinforced;
import slimeknights.tconstruct.tools.modifiers.ModSharpness;
import slimeknights.tconstruct.tools.modifiers.ModShulking;
import slimeknights.tconstruct.tools.modifiers.ModSilktouch;
import slimeknights.tconstruct.tools.modifiers.ModSoulbound;
import slimeknights.tconstruct.tools.modifiers.ModWebbed;
import slimeknights.tconstruct.tools.traits.InfiTool;

@Pulse(id="TinkerModifiers", description="All the modifiers in one handy package", pulsesRequired="TinkerTools", forced=true)
public class TinkerModifiers
extends AbstractToolPulse {
    public static final String PulseId = "TinkerModifiers";
    static final Logger log = Util.getLogger("TinkerModifiers");
    @SidedProxy(clientSide="slimeknights.tconstruct.tools.ToolClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static Modifier modBaneOfArthopods;
    public static Modifier modBeheading;
    public static Modifier modBlasting;
    public static Modifier modDiamond;
    public static Modifier modEmerald;
    public static Modifier modFiery;
    public static Modifier modFins;
    public static Modifier modGlowing;
    public static Modifier modHaste;
    public static Modifier modHarvestWidth;
    public static Modifier modHarvestHeight;
    public static Modifier modKnockback;
    public static ModLuck modLuck;
    public static Modifier modMendingMoss;
    public static Modifier modNecrotic;
    public static Modifier modReinforced;
    public static Modifier modSharpness;
    public static Modifier modShulking;
    public static Modifier modSilktouch;
    public static Modifier modWebbed;
    public static Modifier modSmite;
    public static Modifier modSoulbound;
    public static Modifier modCreative;
    public static List<Modifier> fortifyMods;

    @Override
    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        this.registerModifiers();
    }

    @Override
    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        this.registerFortifyModifiers();
    }

    protected void registerModifiers() {
        ItemStack tnt = new ItemStack(Blocks.field_150335_W);
        ItemStack glowstoneDust = new ItemStack(Items.field_151114_aO);
        modBaneOfArthopods = new ModAntiMonsterType("bane_of_arthopods", 6404681, 5, 24, EnumCreatureAttribute.ARTHROPOD);
        modBaneOfArthopods = this.registerModifier(modBaneOfArthopods);
        modBaneOfArthopods.addItem(Items.field_151071_bq);
        modBeheading = this.registerModifier(new ModBeheading());
        modBeheading.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack(Items.field_151079_bi), new ItemStack(Blocks.field_150343_Z)}));
        modBlasting = this.registerModifier(new ModBlasting());
        modBlasting.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{tnt, tnt, tnt}));
        modDiamond = this.registerModifier(new ModDiamond());
        modDiamond.addItem("gemDiamond");
        modEmerald = this.registerModifier(new ModEmerald());
        modEmerald.addItem("gemEmerald");
        modFiery = this.registerModifier(new ModFiery());
        modFiery.addItem(Items.field_151065_br);
        modFins = this.registerModifier(new ModFins());
        modFins.addItem("fish", 2, 1);
        modGlowing = this.registerModifier(new ModGlowing());
        modGlowing.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{glowstoneDust, new ItemStack(Items.field_151061_bv), glowstoneDust}));
        modHaste = this.registerModifier(new ModHaste(50));
        modHaste.addItem("dustRedstone");
        modHaste.addItem("blockRedstone", 1, 9);
        modHarvestWidth = this.registerModifier(new ModHarvestSize("width"));
        modHarvestWidth.addItem(TinkerCommons.matExpanderW, 1, 1);
        modHarvestHeight = this.registerModifier(new ModHarvestSize("height"));
        modHarvestHeight.addItem(TinkerCommons.matExpanderH, 1, 1);
        modKnockback = this.registerModifier(new ModKnockback());
        modKnockback.addItem((Block)Blocks.field_150331_J, 1);
        modKnockback.addItem((Block)Blocks.field_150320_F, 1);
        modLuck = this.registerModifier(new ModLuck());
        modLuck.addItem("gemLapis");
        modLuck.addItem("blockLapis", 1, 9);
        modMendingMoss = this.registerModifier(new ModMendingMoss());
        modMendingMoss.addItem(TinkerCommons.matMendingMoss, 1, 1);
        modNecrotic = this.registerModifier(new ModNecrotic());
        modNecrotic.addItem(TinkerCommons.matNecroticBone, 1, 1);
        modReinforced = this.registerModifier(new ModReinforced());
        modReinforced.addItem(TinkerCommons.matReinforcement, 1, 1);
        modSharpness = this.registerModifier(new ModSharpness(72));
        modSharpness.addItem("gemQuartz");
        modSharpness.addItem("blockQuartz", 1, 4);
        modShulking = this.registerModifier(new ModShulking());
        modShulking.addItem(Items.field_185162_cT);
        modSilktouch = this.registerModifier(new ModSilktouch());
        modSilktouch.addItem(TinkerCommons.matSilkyJewel, 1, 1);
        modWebbed = this.registerModifier(new ModWebbed());
        modWebbed.addItem(Blocks.field_150321_G, 1);
        modSmite = new ModAntiMonsterType("smite", 15258880, 5, 24, EnumCreatureAttribute.UNDEAD);
        modSmite = this.registerModifier(modSmite);
        modSmite.addItem(TinkerCommons.consecratedSoil, 1, 1);
        modSoulbound = this.registerModifier(new ModSoulbound());
        modSoulbound.addItem(Items.field_151156_bN);
        modCreative = this.registerModifier(new ModCreative());
        modCreative.addItem(TinkerCommons.matCreativeModifier, 1, 1);
        TinkerRegistry.addTrait(InfiTool.INSTANCE);
    }

    private void registerFortifyModifiers() {
        fortifyMods = Lists.newArrayList();
        for (Material mat : TinkerRegistry.getAllMaterialsWithStats("head")) {
            fortifyMods.add(new ModFortify(mat));
        }
    }
}

