/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.library.fluid.IFluidTankUpdater;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;

public class TileTank
extends TileSmelteryComponent
implements IFluidTankUpdater {
    public static final int CAPACITY = 4000;
    protected FluidTankAnimated tank = new FluidTankAnimated(4000, (TileEntity)this);
    private int lastStrength = -1;

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public FluidTankAnimated getInternalTank() {
        return this.tank;
    }

    public boolean containsFluid() {
        return this.tank.getFluid() != null;
    }

    public int getBrightness() {
        if (this.containsFluid()) {
            return this.tank.getFluid().getFluid().getLuminosity();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateFluidTo(FluidStack fluid) {
        int oldAmount = this.tank.getFluidAmount();
        this.tank.setFluid(fluid);
        this.tank.renderOffset += (float)(this.tank.getFluidAmount() - oldAmount);
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readTankFromNBT(tags);
    }

    public void readTankFromNBT(NBTTagCompound tags) {
        this.tank.readFromNBT(tags);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags = super.func_189515_b(tags);
        this.writeTankToNBT(tags);
        return tags;
    }

    public void writeTankToNBT(NBTTagCompound tags) {
        this.tank.writeToNBT(tags);
    }

    public int comparatorStrength() {
        return 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    @Override
    public void onTankContentsChanged() {
        int newStrength = this.comparatorStrength();
        if (newStrength != this.lastStrength) {
            this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q());
            this.lastStrength = newStrength;
        }
    }
}

