/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.smeltery.block.BlockTinkerTankController;
import slimeknights.tconstruct.smeltery.client.SmelteryTankRenderer;
import slimeknights.tconstruct.smeltery.tileentity.TileTinkerTank;

public class TinkerTankRenderer
extends SmelteryTankRenderer<TileTinkerTank> {
    protected static Minecraft mc = Minecraft.func_71410_x();

    public void renderTileEntityAt(@Nonnull TileTinkerTank tinkerTank, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!tinkerTank.isActive()) {
            return;
        }
        BlockPos tilePos = tinkerTank.func_174877_v();
        BlockPos minPos = tinkerTank.getMinPos();
        BlockPos maxPos = tinkerTank.getMaxPos();
        if (minPos == null || maxPos == null) {
            return;
        }
        SmelteryTank tank = tinkerTank.getTank();
        World world = tinkerTank.func_145831_w();
        IBlockState state = world.func_180495_p(tilePos);
        if (state.func_177230_c() instanceof BlockTinkerTankController) {
            FluidStack fluidStack = tank.getFluid();
            if (fluidStack == null) {
                fluidStack = new FluidStack(FluidRegistry.WATER, 1000);
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer renderer = tessellator.func_178180_c();
            renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            TinkerTankRenderer.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            EnumFacing face = (EnumFacing)world.func_180495_p(tilePos).func_177229_b((IProperty)BlockTinkerTankController.FACING);
            Fluid fluid = fluidStack.getFluid();
            TextureAtlasSprite sprite = mc.func_147117_R().getTextureExtry(fluid.getStill().toString());
            int brightness = world.func_175626_b(tilePos.func_177972_a(face), fluid.getLuminosity(fluidStack));
            int color = fluid.getColor(fluidStack);
            RenderUtil.pre(x, y, z);
            if (sprite == null) {
                sprite = mc.func_147117_R().func_174944_f();
            }
            float d = RenderUtil.FLUID_OFFSET;
            float d2 = 1.0f - d * 2.0f;
            GlStateManager.func_179084_k();
            RenderUtil.putTexturedQuad(renderer, sprite, d, d, d, d2, d2 - 0.3f, d2, face, color, brightness, false);
            tessellator.func_78381_a();
            RenderUtil.post();
        }
        this.renderFluids(tank, tilePos, minPos.func_177982_a(-1, 0, -1), maxPos.func_177982_a(1, 0, 1), x, y, z, 0.0625f, minPos);
    }
}

